/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.entity.CategoryRelationEntity;
import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.service.ICategoryRelationService;
import com.ejianc.business.contractbase.service.IClauseSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"clauseSettingController"})
public class ClauseSettingController {
    private static final String BILL_CODE = "CATEGORY_RELATION";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IClauseSettingService service;
    @Autowired
    private ICategoryRelationService relationService;
    @Autowired
    private ITemplateCategoryService categoryService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ClauseSettingVO> saveOrUpdate(@RequestBody ClauseSettingVO saveorUpdateVO) {
        ClauseSettingEntity entity = (ClauseSettingEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ClauseSettingEntity.class));
        if (null == entity.getId()) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (saveorUpdateVO.getIds().isEmpty()) {
                throw new BusinessException("\u65b0\u589e \u6761\u6b3e\u8bf7\u6307\u5b9a\u5bf9\u5e94\u5206\u7c7b");
            }
            if (billCode.isSuccess()) {
                entity.setId(IdWorker.getId());
                entity.setEnableStatus(1);
                entity.setCode((String)billCode.getData());
                entity.setTenantId(InvocationInfoProxy.getTenantid());
                int sum = this.relationService.saveCategoryRelation(entity, saveorUpdateVO.getIds());
                if (this.getCategoryCount() == sum) {
                    entity.setEnableType(1);
                } else {
                    entity.setEnableType(2);
                }
            }
            entity.setNecessaryStatus(0);
        } else {
            entity = (ClauseSettingEntity)((Object)this.service.selectById(entity.getId()));
            if (saveorUpdateVO.getEnableStatus().equals(entity.getEnableStatus())) {
                entity.setClauseName(saveorUpdateVO.getClauseName());
                entity.setRangeIds(saveorUpdateVO.getRangeIds());
                entity.setRangeNames(saveorUpdateVO.getRangeNames());
                entity.setSequence(saveorUpdateVO.getSequence());
                entity.setContent(saveorUpdateVO.getContent());
                entity.setNecessaryStatus(saveorUpdateVO.getNecessaryStatus());
                int sum = this.relationService.saveCategoryRelation(entity, entity.getRangeIds());
                if (this.getCategoryCount() == sum) {
                    entity.setEnableType(1);
                } else {
                    entity.setEnableType(2);
                }
            } else {
                entity.setEnableStatus(saveorUpdateVO.getEnableStatus());
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ClauseSettingVO map = (ClauseSettingVO)BeanMapper.map((Object)((Object)entity), ClauseSettingVO.class);
        return CommonResponse.success((Object)map);
    }

    @RequestMapping(value={"/queryPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ClauseSettingVO>> queryPage(@RequestBody QueryParam param) {
        if (null != param.getParams() && null != param.getParams().get("categoryId")) {
            TemplateCategoryEntity cateogory = (TemplateCategoryEntity)((Object)this.categoryService.selectById(Long.valueOf(((Parameter)param.getParams().get("categoryId")).getValue().toString())));
            if (null != cateogory) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"dr", (Object)0);
                query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                query.likeRight((Object)"category_inner_code", (Object)cateogory.getInnerCode());
                List categoryRelationEntities = this.relationService.list((Wrapper)query);
                if (CollectionUtils.isNotEmpty((Collection)categoryRelationEntities)) {
                    ComplexParam c1 = new ComplexParam();
                    c1.setLogic("and");
                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic("or");
                    c2.getParams().put("id", new Parameter("in", categoryRelationEntities.stream().map(CategoryRelationEntity::getClauseId).collect(Collectors.toList())));
                    ComplexParam c3 = new ComplexParam();
                    c3.setLogic("or");
                    c3.getParams().put("enableType", new Parameter("eq", (Object)1));
                    c1.getComplexParams().add(c2);
                    c1.getComplexParams().add(c3);
                    param.getComplexParams().add(c1);
                } else {
                    param.getParams().put("enableType", new Parameter("eq", (Object)1));
                }
            } else {
                return CommonResponse.error((String)"\u62db\u6807\u7c7b\u522b\u4e0d\u652f\u6301\u6dfb\u52a0\u5408\u540c\u6761\u6b3e\uff01");
            }
            param.getParams().remove("categoryId");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence", "asc");
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        List categoryVoList = BeanMapper.mapList((Iterable)page.getRecords(), ClauseSettingVO.class);
        Page categoryVoPage = new Page();
        categoryVoPage.setCurrent(page.getCurrent());
        categoryVoPage.setRecords(categoryVoList);
        categoryVoPage.setSize(page.getSize());
        categoryVoPage.setTotal(page.getTotal());
        categoryVoPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)categoryVoPage);
    }

    @RequestMapping(value={"/updateLitter"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ClauseSettingVO> updateLitter(@RequestBody ClauseSettingVO t) {
        ClauseSettingEntity clauseSettingEntity = (ClauseSettingEntity)((Object)this.service.selectById(t.getId()));
        clauseSettingEntity.setClauseName(t.getClauseName());
        clauseSettingEntity.setSequence(t.getSequence());
        this.service.saveOrUpdate((Object)clauseSettingEntity, false);
        ClauseSettingVO vo = (ClauseSettingVO)BeanMapper.map((Object)((Object)clauseSettingEntity), ClauseSettingVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.service.removeRelationByClause(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ClauseSettingVO> updateStatus(@RequestBody ClauseSettingVO clauseSettingVO) {
        ClauseSettingVO vo = this.service.updateStatus(clauseSettingVO);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)vo);
    }

    private int getCategoryCount() {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("is_top", new Parameter("eq", (Object)"0"));
        List templateCategoryEntities = this.categoryService.queryList(queryParam);
        return templateCategoryEntities.size();
    }

    @ResponseBody
    @RequestMapping(value={"/queryClauseSetting"}, method={RequestMethod.GET})
    public CommonResponse<IPage<ClauseSettingVO>> queryClauseSetting(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        String categoryId = "categoryId";
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("clauseName");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("enableStatus", new Parameter("eq", (Object)"1"));
        boolean onlyQueryAll = true;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            String ns = String.valueOf(conditionMap.get("necessaryStatus"));
            if (StringUtils.isNotBlank((CharSequence)ns) && !"null".equals(ns)) {
                List nsList = Arrays.stream(ns.split(",")).map(Integer::parseInt).collect(Collectors.toList());
                queryParam.getParams().put("necessaryStatus", new Parameter("in", nsList));
            }
            if (null != conditionMap.get(categoryId)) {
                Long id = Long.parseLong(conditionMap.get(categoryId).toString());
                QueryParam query = new QueryParam();
                query.getParams().put(categoryId, new Parameter("eq", (Object)id));
                List categoryRelationEntities = this.relationService.queryList(query, false);
                if (!categoryRelationEntities.isEmpty()) {
                    ComplexParam c1 = new ComplexParam();
                    c1.setLogic("and");
                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic("or");
                    c2.getParams().put("id", new Parameter("in", categoryRelationEntities.stream().map(CategoryRelationEntity::getClauseId).collect(Collectors.toList())));
                    ComplexParam c3 = new ComplexParam();
                    c3.setLogic("or");
                    c3.getParams().put("enableType", new Parameter("eq", (Object)1));
                    c1.getComplexParams().add(c2);
                    c1.getComplexParams().add(c3);
                    queryParam.getComplexParams().add(c1);
                    onlyQueryAll = false;
                }
            }
        }
        if (onlyQueryAll) {
            queryParam.getParams().put("enableType", new Parameter("eq", (Object)1));
        }
        queryParam.getOrderMap().put("sequence", "asc");
        queryParam.getOrderMap().put("create_time", "desc");
        IPage pageData = this.service.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), ClauseSettingVO.class));
        return CommonResponse.success((Object)result);
    }
}

