package com.ejianc.business.contractbase.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.entity.TemplateEntity;
import com.ejianc.business.contractbase.entity.TemplateSignatoryRectEntity;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.service.ITemplateSignatoryRectService;
import com.ejianc.business.contractbase.vo.TemplateSignatoryRectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/signatoryRect")
public class SignatoryRectController {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	IBillCodeApi billCodeApi;
	@Autowired
	private ITemplateSignatoryRectService service;

	@Autowired
	private ITemplateService templateService;


	@PostMapping(value = "/saveOrUpdate")
	public CommonResponse<List<TemplateSignatoryRectVO>> saveOrUpdate(@Validated @RequestBody List<TemplateSignatoryRectVO> templateSignatoryRectVOS) {
		Long templateId = templateSignatoryRectVOS.get(0).getTemplateId();
		// 先批量删除后批量插入
		service.batchRemove(templateSignatoryRectVOS.stream().map(TemplateSignatoryRectVO::getTemplateId).distinct().collect(Collectors.toList()));

		List<TemplateSignatoryRectVO> saveVos = templateSignatoryRectVOS.stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
		if(CollectionUtils.isNotEmpty(saveVos)) {
			service.saveOrUpdateBatch(BeanMapper.mapList(saveVos, TemplateSignatoryRectEntity.class));
		}
		List<TemplateSignatoryRectEntity> data = service.list(new LambdaQueryWrapper<TemplateSignatoryRectEntity>().eq(TemplateSignatoryRectEntity::getTemplateId, templateId));
		return CommonResponse.success("签章定位保存成功！", BeanMapper.mapList(data, TemplateSignatoryRectVO.class));
	}

	/**
	 * 根据模板id查询签章定位
	 *
	 * @param templateId 合同模版id
	 *
	 * @return 签章定位
	 */
	@GetMapping(value = "/queryList")
	public CommonResponse<List<TemplateSignatoryRectVO>> queryList(@RequestParam(value = "templateId") Long templateId) {
		Assert.notNull(templateId, "合同模板id不能为空！");
		LambdaQueryWrapper<TemplateSignatoryRectEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TemplateSignatoryRectEntity::getDr, 0);
		queryWrapper.eq(TemplateSignatoryRectEntity::getTemplateId, templateId);
		queryWrapper.orderByAsc(TemplateSignatoryRectEntity::getPartyCode);
		List<TemplateSignatoryRectEntity> entityList = service.list(queryWrapper);
		return CommonResponse.success("签章定位查询成功！", BeanMapper.mapList(entityList, TemplateSignatoryRectVO.class));
	}

	// todo:增加全局统一异常处理（替代平台的报错提示）


	/**
	 * 根据合同分类id查询合同模版的签章定位信息
	 *
	 * @param categoryId 合同分类id
	 *
	 * @return List<TemplateSignatoryRectVO> 合同模版的签章定位信息
	 */
	@GetMapping(value = "/fetchSignatoryRect")
	public CommonResponse<List<TemplateSignatoryRectVO>> fetchSignatoryRect(@RequestParam(value = "categoryId") Long categoryId) {
		Assert.notNull(categoryId, "合同分类id不能为空！");
		LambdaQueryWrapper<TemplateEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(TemplateEntity::getDr, 0);
		wrapper.eq(TemplateEntity::getEnableStatus, 1);
		wrapper.eq(TemplateEntity::getCategoryId, categoryId);
		TemplateEntity template = templateService.getOne(wrapper);
		if (template == null) {
			return CommonResponse.error("根据合同分类查询合同模版失败！");
		}
		Assert.notNull(template.getId(), "合同模版id不能为空！");
		LambdaQueryWrapper<TemplateSignatoryRectEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TemplateSignatoryRectEntity::getDr, 0);
		queryWrapper.eq(TemplateSignatoryRectEntity::getTemplateId, template.getId());
		queryWrapper.orderByAsc(TemplateSignatoryRectEntity::getPartyCode);
		List<TemplateSignatoryRectEntity> entityList = service.list(queryWrapper);
		return CommonResponse.success("合同模版签章定位信息查询成功！", BeanMapper.mapList(entityList, TemplateSignatoryRectVO.class));
	}


}
