package com.ejianc.business.contractbase.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 签章定位实体
 */
@TableName("ejc_conbase_contract_template_signatory_rect")
public class TemplateSignatoryRectEntity extends BaseEntity {
	private static final long serialVersionUID = 3290810247771967581L;

	@TableField("party_name")
	private String partyName;// 合同方名称
	@TableField("party_code")
	private Integer partyCode;// 合同方编码
	@TableField("org_id")
	private Long orgId;// 签署方组织id(平台内,外部单位为空)
	@TableField("org_name")
	private String orgName;// 签署方组织名称
	@TableField("org_code")
	private String orgCode;// 签署方组织编码
	@TableField("signature_type")
	private Integer signatureType;// 签署方单位类型 0-内部单位，1-外部单位
	@TableField("seal_type")
	private String sealType;// 印章类型,COMPANY("企业公章"),LP("法定代表人章"),PERSONAL("个人签字")
	@TableField("seal_sub_type_name")
	private String sealSubTypeName;// 印章类型名称子类别
	@TableField("keywords")
	private String keywords;// 定位关键字
	@TableField("timestamp_flag")
	private Boolean timeStampFlag;// 是否启用时间戳，0-否，1-是
	@TableField("timestamp_keywords")
	private String timeStampKeyWords;// 时间戳关键字
	@TableField("across_flag")
	private Boolean acrossFlag;// 是否开启骑缝章，0-否，1-是
	@TableField("across_setting")
	private String acrossSetting;// 骑缝章设置，ACROSS_PAGE-添加至全部页；ACROSS_PAGE_ODD-添加至奇数页；默认全页
	@TableField("template_id")
	private Long templateId;// 模版id
	@TableField("source_company_id")
	private Long sourceCompanyId;// 第三方公司id
	@TableField("source_company_name")
	private String sourceCompanyName;// 第三公司名称
	@TableField("source_seal_id")
	private Long sourceSealId;// 第三方印章id
	@TableField("source_seal_name")
	private String sourceSealName;// 第三方印章名称
	@TableField("source_status_description")
	private String sourceStatusDescription;// 第三方印章状态名称
	@TableField("seal_id")
	private Long sealId;// 印章Id


	public String getPartyName() {
		return partyName;
	}

	public void setPartyName(String partyName) {
		this.partyName = partyName;
	}

	public Integer getPartyCode() {
		return partyCode;
	}

	public void setPartyCode(Integer partyCode) {
		this.partyCode = partyCode;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public Integer getSignatureType() {
		return signatureType;
	}

	public void setSignatureType(Integer signatureType) {
		this.signatureType = signatureType;
	}

	public String getSealType() {
		return sealType;
	}

	public void setSealType(String sealType) {
		this.sealType = sealType;
	}

	public String getSealSubTypeName() {
		return sealSubTypeName;
	}

	public void setSealSubTypeName(String sealSubTypeName) {
		this.sealSubTypeName = sealSubTypeName;
	}

	public String getKeywords() {
		return keywords;
	}

	public void setKeywords(String keywords) {
		this.keywords = keywords;
	}

	public Boolean getTimeStampFlag() {
		return timeStampFlag;
	}

	public void setTimeStampFlag(Boolean timeStampFlag) {
		this.timeStampFlag = timeStampFlag;
	}

	public String getTimeStampKeyWords() {
		return timeStampKeyWords;
	}

	public void setTimeStampKeyWords(String timeStampKeyWords) {
		this.timeStampKeyWords = timeStampKeyWords;
	}

	public Boolean getAcrossFlag() {
		return acrossFlag;
	}

	public void setAcrossFlag(Boolean acrossFlag) {
		this.acrossFlag = acrossFlag;
	}

	public String getAcrossSetting() {
		return acrossSetting;
	}

	public void setAcrossSetting(String acrossSetting) {
		this.acrossSetting = acrossSetting;
	}

	public Long getTemplateId() {
		return templateId;
	}

	public void setTemplateId(Long templateId) {
		this.templateId = templateId;
	}

	public Long getSourceCompanyId() {
		return sourceCompanyId;
	}

	public void setSourceCompanyId(Long sourceCompanyId) {
		this.sourceCompanyId = sourceCompanyId;
	}

	public String getSourceCompanyName() {
		return sourceCompanyName;
	}

	public void setSourceCompanyName(String sourceCompanyName) {
		this.sourceCompanyName = sourceCompanyName;
	}

	public Long getSourceSealId() {
		return sourceSealId;
	}

	public void setSourceSealId(Long sourceSealId) {
		this.sourceSealId = sourceSealId;
	}

	public String getSourceSealName() {
		return sourceSealName;
	}

	public void setSourceSealName(String sourceSealName) {
		this.sourceSealName = sourceSealName;
	}

	public String getSourceStatusDescription() {
		return sourceStatusDescription;
	}

	public void setSourceStatusDescription(String sourceStatusDescription) {
		this.sourceStatusDescription = sourceStatusDescription;
	}

	public Long getSealId() {
		return sealId;
	}

	public void setSealId(Long sealId) {
		this.sealId = sealId;
	}
}

