/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.pool.contractpool.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.mapper.TemplateCategoryMapper;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.bean.SubLeaderEntity;
import com.ejianc.business.contractbase.pool.contractpool.bean.SupplierEntity;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.contractpool.service.ISubLeaderService;
import com.ejianc.business.contractbase.pool.contractpool.service.ISupplierService;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolNameVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplierVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.util.ReferTool;
import com.ejianc.business.contractbase.vo.report.PayContractVO;
import com.ejianc.business.contractbase.vo.report.SubUnitTopVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.supplier.api.IShareSubleadersApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"contractPool"})
public class ContractPoolController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractPoolService service;
    @Autowired
    private TemplateCategoryMapper templateCategoryMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String BILL_CODE = "CONTRACT_POOL";
    private final String FILLING_TYPE_STATE = "P-eg7rBO0134";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IShareSubleadersApi shareSubleadersApi;
    @Autowired
    private ISubLeaderService subLeaderService;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<ContractPoolVO> queryDetail(Long id) {
        ContractPoolEntity entity = (ContractPoolEntity)((Object)this.service.selectById(id));
        ContractPoolVO vo = (ContractPoolVO)BeanMapper.map((Object)((Object)entity), ContractPoolVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<ContractPoolVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractPoolVO vo : vos) {
                CommonResponse res = this.billTypeApi.checkQuote("EJCBT202204000016", vo.getId());
                this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
                if (res.isSuccess()) continue;
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<ContractPoolVO> saveOrUpdate(@RequestBody ContractPoolVO saveOrUpdateVO) {
        ContractPoolEntity entity = (ContractPoolEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractPoolEntity.class));
        if (null == entity.getId() && StringUtils.isBlank((CharSequence)entity.getContractCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCodeRes = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCodeRes.isSuccess()) {
                entity.setContractCode((String)billCodeRes.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setAddType(2);
        entity.setContractTaxMny(entity.getBaseTaxMny());
        entity.setContractMny(entity.getBaseTaxMny());
        entity.setContractTax(entity.getBaseTax());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)entity), ContractPoolVO.class));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        param.getFuzzyFields().addAll(Arrays.asList("contractCode", "contractName", "projectName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = null;
        String orgType = null;
        if (null == param.getParams().get("projectId")) {
            if (null != param.getParams().get("orgId") && null != param.getParams().get("orgType")) {
                orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
                orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString();
                param.getParams().remove("orgId");
                param.getParams().remove("orgType");
            } else {
                orgType = InvocationInfoProxy.getOrgType();
                orgId = InvocationInfoProxy.getOrgId();
            }
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(orgType))) {
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        String projectRange = null != param.getParams().get("projectRange") ? ((Parameter)param.getParams().get("projectRange")).getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? ((Parameter)param.getParams().get("dateIn")).getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");
        if (StringUtils.isNotBlank((CharSequence)projectRange) || StringUtils.isNotBlank((CharSequence)dateIn)) {
            CommonResponse projectIdsResp = this.projectPoolApi.queryProjectIdsByorgId(orgId, projectRange, dateIn);
            if (!projectIdsResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)projectIdsResp));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)projectIdsResp.getData()))) {
                param.getParams().put("projectId", new Parameter("in", projectIdsResp.getData()));
            } else {
                this.logger.info("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u4e3a\u7a7a, \u5219\u8fd4\u56de\u7a7a\u7684\u6570\u636e\u5217\u8868\uff01");
                resp.put("current", (Object)param.getPageIndex());
                resp.put("size", (Object)param.getPageSize());
                resp.put("pages", (Object)0);
                resp.put("totalMny", (Object)0);
                resp.put("total", (Object)0);
                resp.put("records", new ArrayList());
                return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
            }
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("totalMny", (Object)this.service.calcTotalMny(param));
        resp.put("records", (Object)BeanMapper.mapList((Iterable)page.getRecords(), ContractPoolVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/queryListJson"}, method={RequestMethod.POST})
    public CommonResponse<IPage<ContractPoolNameVO>> queryListJson(HttpServletRequest request, @RequestBody QueryParam param) {
        String syncMode = request.getParameter("syncMode");
        if ("increment".equals(syncMode)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            String syncTime = dateFormat.format(calendar.getTime()) + " 00:00:00";
            param.getParams().put("syncTime", new Parameter("eq", (Object)syncTime));
        }
        List<ContractPoolEntity> page = this.service.queryMdmPage(param);
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)param.getPageSize());
        if (page != null) {
            List records = BeanMapper.mapList(page, ContractPoolVO.class);
            pageData.setRecords(this.convertPoolVo(records));
        }
        this.logger.info("\u4e3b\u6570\u636e\u540c\u6b65\uff1a\u53c2\u6570\uff1a{},\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)param), (Object)JSONObject.toJSONString(page));
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u540c\u6b65\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, ContractPoolVO.class);
            for (ContractPoolVO vo : voList) {
                Integer supplementFlag;
                Integer changeStatus;
                String performanceStatus;
                if (vo == null) continue;
                Integer contractProperty = vo.getContractProperty();
                if (contractProperty != null) {
                    if (1 == contractProperty) {
                        vo.setContractPropertyName("\u6536\u5165");
                    } else {
                        vo.setContractPropertyName("\u652f\u51fa");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(performanceStatus = vo.getPerformanceStatus()))) {
                    ContractPerformanceStateEnum performanceStateEnum = ContractPerformanceStateEnum.getByStateCode((String)performanceStatus);
                    vo.setPerformanceStatusName(performanceStateEnum != null ? performanceStateEnum.getStateName() : "");
                }
                if ((changeStatus = vo.getChangeStatus()) != null) {
                    switch (changeStatus) {
                        case 1: {
                            vo.setChangeStatusName("\u672a\u53d8\u66f4");
                            break;
                        }
                        case 2: {
                            vo.setChangeStatusName("\u53d8\u66f4\u4e2d");
                            break;
                        }
                        case 3: {
                            vo.setChangeStatusName("\u5df2\u53d8\u66f4");
                            break;
                        }
                    }
                }
                if ((supplementFlag = vo.getSupplementFlag()) != null) {
                    if (1 == supplementFlag) {
                        vo.setSupplementFlagName("\u662f");
                    } else {
                        vo.setSupplementFlagName("\u5426");
                    }
                }
                vo.setHandleTypeStr(Integer.valueOf("1").equals(vo.getHandleType()) ? "\u624b\u52a8\u8865\u5f55" : "\u4e1a\u52a1\u63a8\u9001");
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("ContractPool-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refContractPoolDataList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractPoolVO>> getCategoryParent(@RequestParam(value="pageNumber") Integer pageNumber, @RequestParam(value="pageSize") Integer pageSize, String searchText, String searchObject, String condition, String relyCondition) {
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber.intValue());
        param.setPageSize(pageSize.intValue());
        param.setSearchObject(searchObject);
        param.setSearchText(searchText);
        param.setFuzzyFields(Arrays.asList("contractCode", "contractName", "projectName", "partyaName", "partybName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Map<String, Parameter> parameterMap = ReferTool.parseCondition(relyCondition);
        parameterMap.keySet().forEach(key -> {
            Parameter cfr_ignored_0 = (Parameter)param.getParams().put(key, parameterMap.get(key));
        });
        if (null != param.getParams().get("categoryId")) {
            String categoryId = ((Parameter)param.getParams().get("categoryId")).getValue().toString();
            QueryWrapper wapper = new QueryWrapper();
            wapper.likeRight((Object)"inner_code", (Object)categoryId);
            List categoryEntityList = this.templateCategoryMapper.selectList((Wrapper)wapper);
            if (CollectionUtils.isNotEmpty((Collection)categoryEntityList)) {
                List categoryIdList = categoryEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                param.getParams().put("categoryId", new Parameter("in", categoryIdList));
            }
        }
        String filingTypeConfig = "0";
        CommonResponse response = this.paramConfigApi.getByCode("P-eg7rBO0134");
        if (!response.isSuccess() || response.getData() == null) {
            this.logger.error("\u6839\u636e\u5f52\u6863\u53c2\u6570\u7f16\u7801-{}\uff0c\u67e5\u8be2\u7cfb\u7edf\u53c2\u6570\uff08\u5408\u540c\u5f52\u6863\u63a7\u5236\uff09\u914d\u7f6e\u4fe1\u606f\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)"P-eg7rBO0134", (Object)response.getMsg());
        } else if (null != ((ParamRegisterSetVO)response.getData()).getValueData()) {
            filingTypeConfig = ((ParamRegisterSetVO)response.getData()).getValueData();
        }
        if (!"0".equals(filingTypeConfig)) {
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("filingStatus", new Parameter("eq", (Object)1));
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("contractProperty", new Parameter("eq", (Object)1));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            param.getComplexParams().add(c1);
        }
        ArrayList performanceStatusList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            String performanceStatusParam;
            String sourceTypes;
            JSONObject conditionJson = JSONObject.parseObject((String)condition);
            String sourceType = conditionJson.getString("sourceType");
            if (StringUtils.isNotBlank((CharSequence)sourceType)) {
                param.getParams().put("sourceType", new Parameter("eq", (Object)sourceType));
            }
            if (StringUtils.isNotBlank((CharSequence)(sourceTypes = conditionJson.getString("sourceTypes")))) {
                param.getParams().put("sourceType", new Parameter("in", Arrays.asList(sourceTypes.split(","))));
            }
            if (StringUtils.isNotBlank((CharSequence)conditionJson.getString("contractProperty"))) {
                param.getParams().put("contractProperty", new Parameter("eq", (Object)conditionJson.getInteger("contractProperty")));
            }
            if (StringUtils.isNotBlank((CharSequence)(performanceStatusParam = conditionJson.getString("performanceStatus")))) {
                performanceStatusList = Lists.newArrayList((Object[])performanceStatusParam.split(","));
            }
            String projectId = conditionJson.getString("projectId");
            String orgId = conditionJson.getString("orgId");
            String orgType = conditionJson.getString("orgType");
            if (StringUtils.isBlank((CharSequence)projectId) && StringUtils.isBlank((CharSequence)orgId) && StringUtils.isBlank((CharSequence)orgType)) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u67e5\u8be2\u53c2\u6570projectId\u6216\u7ec4\u7ec7\u8fc7\u6ee4\u53c2\u6570-orgId,orgType\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)projectId)) {
                this.logger.info("condition\u4e2dprojectId\uff1a{}", (Object)projectId);
                param.getParams().put("projectId", new Parameter("eq", (Object)Long.valueOf(projectId)));
            } else {
                if (StringUtils.isBlank((CharSequence)orgId)) {
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u7ec4\u7ec7\u8fc7\u6ee4\u53c2\u6570-orgId\uff01");
                }
                if (StringUtils.isBlank((CharSequence)orgType)) {
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u7ec4\u7ec7\u8fc7\u6ee4\u53c2\u6570-orgType\uff01");
                }
                if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(orgType)) {
                    param.getParams().put("orgId", new Parameter("eq", (Object)Long.valueOf(orgId)));
                } else {
                    CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(Long.valueOf(orgId));
                    if (!orgResp.isSuccess()) {
                        this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                }
            }
            if (null != conditionJson.get((Object)"orderType")) {
                if ("asc".equals(conditionJson.getString("orderType"))) {
                    param.getOrderMap().put("createTime", "asc");
                } else {
                    param.getOrderMap().put("createTime", "desc");
                }
            } else {
                param.getOrderMap().put("createTime", "desc");
            }
        } else {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u67e5\u8be2\u53c2\u6570projectId\u6216\u7ec4\u7ec7\u8fc7\u6ee4\u53c2\u6570-orgId,orgType\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)performanceStatusList)) {
            performanceStatusList.add("2");
        }
        param.getParams().put("performanceStatus", new Parameter("in", (Object)performanceStatusList));
        IPage page = this.service.queryPage(param);
        Page pageDate = new Page();
        pageDate.setCurrent(page.getCurrent());
        pageDate.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractPoolVO.class));
        pageDate.setSize(page.getSize());
        pageDate.setTotal(page.getTotal());
        pageDate.setPages(page.getPages());
        return CommonResponse.success((Object)pageDate);
    }

    private List<ContractPoolNameVO> convertPoolVo(List<ContractPoolVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return new ArrayList<ContractPoolNameVO>();
        }
        ArrayList<ContractPoolNameVO> res = new ArrayList<ContractPoolNameVO>();
        voList.forEach(v -> {
            ContractPoolNameVO vo = (ContractPoolNameVO)BeanMapper.map((Object)v, ContractPoolNameVO.class);
            vo.setOrgId(v.getOrgId() != null ? v.getOrgId().toString() : null);
            vo.setOrgCode(v.getOrgName());
            vo.setCustomerId(v.getPartyaId());
            vo.setCustomerName(v.getPartyaName());
            vo.setSupplierId(v.getPartybId());
            vo.setSupplierCode(v.getPartybName());
            vo.setConstructionPartner(v.getJoinPartyName());
            vo.setContractPartyc(v.getPartycName());
            if (v.getSignDate() != null) {
                vo.setSignDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)v.getSignDate()));
            }
            if (v.getContractStartDate() != null) {
                vo.setStartDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)v.getContractStartDate()));
            }
            if (v.getContractFinishDate() != null) {
                vo.setEndDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)v.getContractFinishDate()));
            }
            vo.setSchedule(v.getContractDaysLimit());
            String performanceStatus = v.getPerformanceStatus();
            if (performanceStatus != null) {
                switch (performanceStatus) {
                    case "1": {
                        vo.setContractStatus("\u672a\u7b7e\u8ba2");
                        break;
                    }
                    case "2": {
                        vo.setContractStatus("\u5c65\u7ea6\u4e2d");
                        break;
                    }
                    case "3": {
                        vo.setContractStatus("\u5df2\u5c01\u8d26");
                        break;
                    }
                    case "4": {
                        vo.setContractStatus("\u5df2\u89e3\u9664");
                        break;
                    }
                }
            }
            vo.setCostChangeTotalMny(v.getTotalChangeMny());
            vo.setCostChangeTotalTaxMny(v.getTotalChangeTaxMny());
            vo.setEmployeeId(v.getEmployeeName());
            vo.setDeptId(v.getDepartmentName());
            res.add(vo);
        });
        return res;
    }

    @GetMapping(value={"/payContractNewSignScale"})
    @ResponseBody
    public CommonResponse<List<PayContractVO>> payContractNewSignScale(@RequestParam(value="yearFlag") Integer yearFlag, @RequestParam(value="orgId", required=false) Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (yearFlag == 0) {
            String beginYearDate = DateUtil.formatDate((Date)DateUtil.beginOfYear((Date)new Date()).toJdkDate());
            String endYearDate = DateUtil.formatDate((Date)DateUtil.endOfYear((Date)new Date()).toJdkDate());
            param.getParams().put("sign_date", new Parameter("between", (Object)(beginYearDate + "," + endYearDate)));
        }
        param.getParams().put("contract_property", new Parameter("eq", (Object)ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode()));
        List list = this.service.queryList(param);
        BigDecimal totalContractTaxMny = list.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        Map<String, List<ContractPoolEntity>> sourceTypeMap = list.stream().filter(e -> e.getSourceType() != null).collect(Collectors.groupingBy(ContractPoolEntity::getSourceType));
        List<Object> resultList = new ArrayList();
        for (Map.Entry<String, List<ContractPoolEntity>> entry : sourceTypeMap.entrySet()) {
            String sourceType = entry.getKey();
            if (!StringUtils.isNotBlank((CharSequence)sourceType)) continue;
            List<ContractPoolEntity> entityList = entry.getValue();
            PayContractVO vo = new PayContractVO();
            BigDecimal contractTaxMny = entityList.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setContractCategoryName(null != ContractTypeEnum.getByCode((String)sourceType) ? ContractTypeEnum.getByCode((String)sourceType).getTypeName() : null);
            vo.setContractCategoryCode(null != ContractTypeEnum.getByCode((String)sourceType) ? ContractTypeEnum.getByCode((String)sourceType).getTypeCode() : null);
            vo.setNum(new BigDecimal(String.valueOf(entityList.size())));
            vo.setAmount(contractTaxMny.setScale(2, RoundingMode.HALF_DOWN));
            vo.setWeight(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)contractTaxMny, (BigDecimal)totalContractTaxMny), (BigDecimal)new BigDecimal("100")).setScale(2, RoundingMode.HALF_DOWN));
            vo.setWeightNum(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getNum(), (BigDecimal)new BigDecimal(String.valueOf(list.size()))), (BigDecimal)new BigDecimal("100")).setScale(2, RoundingMode.HALF_DOWN));
            resultList.add(vo);
        }
        resultList = resultList.stream().sorted(Comparator.comparing(PayContractVO::getAmount).reversed()).collect(Collectors.toList());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resultList);
    }

    @GetMapping(value={"/querySubUnitTopN"})
    @ResponseBody
    public CommonResponse<List<SubUnitTopVO>> querySubUnitTopN(@RequestParam(value="topN", defaultValue="5") Integer topN, @RequestParam(value="mnyFlag") Integer mnyFlag, @RequestParam(value="yearFlag") Integer yearFlag, @RequestParam(value="orgId", required=false) Long orgId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.service.querySubUnitTopN(topN, mnyFlag, yearFlag, orgId));
    }

    @RequestMapping(value={"/downloadExcelModel"})
    @ResponseBody
    public void downloadExcelModel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"ContractPool-import-template.xlsx", (String)"\u5408\u540c\u6c60-\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }

    @ResponseBody
    @RequestMapping(value={"/querySumContract"}, method={RequestMethod.POST})
    public CommonResponse<IPage<SupplierVO>> querySumContract(@RequestBody QueryParam param) {
        CommonResponse<IPage<SupplierVO>> iPageCommonResponse = this.service.querySumContract(param);
        if (!iPageCommonResponse.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return iPageCommonResponse;
    }

    @ResponseBody
    @RequestMapping(value={"/excelExportSumContract"}, method={RequestMethod.POST})
    public void excelExportSumContract(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<IPage<SupplierVO>> iPageCommonResponse = this.service.querySumContract(param);
        List records = ((IPage)iPageCommonResponse.getData()).getRecords();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SupplierList-export.xlsx", beans, response);
    }

    @ResponseBody
    @RequestMapping(value={"/querySumContractDetail"}, method={RequestMethod.GET})
    public CommonResponse<SupplierVO> querySumContractDetail(@RequestParam(value="suplyId") Long suplyId) {
        QueryParam param = new QueryParam();
        Parameter parameter = new Parameter();
        parameter.setValue((Object)suplyId);
        param.getParams().put("suplyId", parameter);
        CommonResponse<IPage<SupplierVO>> iPageCommonResponse = this.service.querySumContract(param);
        if (!iPageCommonResponse.isSuccess() || iPageCommonResponse.getData() == null || ((IPage)iPageCommonResponse.getData()).getRecords() == null || ((IPage)iPageCommonResponse.getData()).getRecords().size() == 0) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
        }
        SupplierVO supplierVO = (SupplierVO)((IPage)iPageCommonResponse.getData()).getRecords().get(0);
        if (null == supplierVO) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
        }
        String supplyTypeName = supplierVO.getSupplyTypeName();
        if (!StringUtils.isEmpty((CharSequence)supplyTypeName)) {
            String str1 = supplyTypeName.substring(0, 1);
            String str2 = supplyTypeName.substring(supplyTypeName.length() - 1, supplyTypeName.length());
            if (str1.equals(",")) {
                supplyTypeName = supplyTypeName.substring(1, supplyTypeName.length());
            }
            if (str2.equals(",")) {
                supplyTypeName = supplyTypeName.substring(0, supplyTypeName.length() - 1);
            }
        }
        supplierVO.setSupplyTypeName(supplyTypeName);
        return CommonResponse.success((Object)supplierVO);
    }

    @GetMapping(value={"/upData"})
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> upData() {
        this.logger.info("\u5f00\u59cb\u6267\u884c\u6570\u636e\u540c\u6b65");
        Integer day = 1;
        Date now = new Date();
        String upDate = com.ejianc.business.contractbase.util.DateUtil.addDay(now, -day.intValue());
        CommonResponse listCommonResponse = this.proSupplierApi.selectByUpDate(upDate);
        this.logger.info("proSupplierApi\u63a5\u53e3\u8c03\u7528\u7ed3\u675f\uff01");
        if (!listCommonResponse.isSuccess()) {
            this.logger.info("\u67e5\u8be2\u6570\u636e\u5931\u8d25!");
            return CommonResponse.error((String)"\u67e5\u8be2\u4f9b\u5e94\u5546\u6570\u636e\u5931\u8d25\uff01");
        }
        if (listCommonResponse.getData() == null || ((List)listCommonResponse.getData()).size() == 0) {
            this.logger.info("\u6570\u636e\u65e0\u66f4\u65b0!");
            return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u57fa\u7840\u6570\u636e\u65e0\u66f4\u65b0\uff01");
        }
        List newData = (List)listCommonResponse.getData();
        this.logger.info("\u83b7\u53d6\u5230\u7684\u6570\u636e\u96c6\u957f\u5ea6\u4e3a:" + newData.size());
        List<SupplierEntity> supplierEntities = BeanMapper.mapList((Iterable)newData, SupplierEntity.class);
        Stream<SupplierEntity> delEntityStream = supplierEntities.stream().filter(item -> item.getDr() == 1);
        ArrayList resIds = new ArrayList();
        List<SupplierEntity> delEntitys = delEntityStream.collect(Collectors.toList());
        delEntitys.forEach(item -> resIds.add(item.getId()));
        this.logger.info("\u6267\u884c\u5220\u9664\u7684\u6570\u636e\u6761\u6570\uff1a" + resIds.size());
        if (resIds.size() > 0) {
            boolean b = this.supplierService.removeByIds(resIds);
            this.logger.info("\u6267\u884c\u5220\u9664\u7ed3\u679c\uff1a" + b);
        }
        Stream<SupplierEntity> entityStream = supplierEntities.stream().filter(item -> item.getDr() == 0);
        supplierEntities = entityStream.collect(Collectors.toList());
        List suplyIds = supplierEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", suplyIds);
        List list = this.supplierService.list((Wrapper)wrapper);
        HashMap versionMap = new HashMap();
        list.forEach(item -> versionMap.put(item.getId(), item.getVersion()));
        supplierEntities.forEach(item -> item.setVersion(null == versionMap.get(item.getId()) ? item.getVersion() : (Integer)versionMap.get(item.getId())));
        this.logger.info("\u6267\u884c\u66f4\u65b0\u7684\u6570\u636e\u6761\u6570\uff1a" + supplierEntities.size());
        if (supplierEntities.size() > 0) {
            boolean b1 = this.supplierService.saveOrUpdateBatch(supplierEntities, supplierEntities.size(), false);
            this.logger.info("\u6267\u884c\u66f4\u65b0\u7ed3\u679c\uff1a" + b1);
        }
        this.logger.info("\u5904\u7406\u6210\u529f\uff01\u6210\u529f\u66f4\u65b0\u4f9b\u5e94\u5546\u6570\u636e" + (supplierEntities.size() + delEntitys.size()) + "\u6761\u6570\u636e\uff01");
        CommonResponse subLeadersResp = this.shareSubleadersApi.selectByUpDateSubLeaders(upDate);
        this.logger.info("\u5f00\u59cb\u5904\u7406\u5f85\u540c\u6b65\u66f4\u65b0\u5206\u5305\u8d1f\u8d23\u4eba\u6570\u636e ------->");
        if (!listCommonResponse.isSuccess()) {
            this.logger.info("\u67e5\u8be2\u5f85\u540c\u6b65\u66f4\u65b0\u5206\u5305\u8d1f\u8d23\u4eba\u6570\u636e\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)subLeadersResp));
            return CommonResponse.error((String)"\u67e5\u8be2\u5f85\u540c\u6b65\u66f4\u65b0\u5206\u5305\u8d1f\u8d23\u4eba\u6570\u636e\u5931\u8d25\uff01");
        }
        List subLeaderList = (List)subLeadersResp.getData();
        if (CollectionUtils.isEmpty((Collection)subLeaderList)) {
            this.logger.info("\u5206\u5305\u8d1f\u8d23\u4eba\u6570\u636e\u65e0\u66f4\u65b0!");
            return CommonResponse.success((String)"\u5206\u5305\u8d1f\u8d23\u4eba\u57fa\u7840\u6570\u636e\u65e0\u66f4\u65b0\uff01");
        }
        ArrayList delSubLeaderIds = new ArrayList();
        ArrayList saveOrUpdateList = new ArrayList();
        subLeaderList.forEach(subLeader -> {
            if (BaseVO.DR_DELETED.equals(subLeader.getDr())) {
                delSubLeaderIds.add(subLeader.getId());
            } else {
                saveOrUpdateList.add(BeanMapper.map((Object)subLeader, SubLeaderEntity.class));
            }
        });
        this.logger.info("\u672c\u6b21\u5f85\u5220\u9664\u5206\u5305\u8d1f\u8d23\u4ebaId-{}", (Object)JSONObject.toJSONString(delSubLeaderIds));
        if (CollectionUtils.isNotEmpty(delSubLeaderIds)) {
            boolean b = this.subLeaderService.removeByIds(delSubLeaderIds);
            this.logger.info("\u5206\u5305\u8d1f\u8d23\u4eba\u6267\u884c\u5220\u9664\u7ed3\u679c\uff1a{}", (Object)b);
        }
        this.logger.info("\u672c\u6b21\u6267\u884c\u66f4\u65b0\u5206\u5305\u8d1f\u8d23\u4eba\u6570\u91cf\uff1a{}", (Object)saveOrUpdateList.size());
        if (CollectionUtils.isNotEmpty(saveOrUpdateList)) {
            List updateIds = saveOrUpdateList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            QueryWrapper subWrapper = new QueryWrapper();
            subWrapper.in((Object)"id", updateIds);
            List dbSubList = this.subLeaderService.list((Wrapper)subWrapper);
            Map<String, SubLeaderEntity> dbListMap = dbSubList.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item));
            saveOrUpdateList.forEach(item -> {
                if (dbListMap.containsKey(item.getId().toString())) {
                    item.setVersion(((SubLeaderEntity)((Object)((Object)dbListMap.get(item.getId().toString())))).getVersion());
                }
            });
            boolean subUpdateRs = this.subLeaderService.saveOrUpdateBatch(saveOrUpdateList, saveOrUpdateList.size(), false);
            this.logger.info("\u672c\u6b21\u5206\u5305\u8d1f\u8d23\u4eba\u66f4\u65b0\u7ed3\u679c\uff1a{}", (Object)subUpdateRs);
        }
        this.logger.info("\u5206\u5305\u8d1f\u8d23\u4eba\u540c\u6b65\u66f4\u65b0\u6210\u529f\uff01");
        return CommonResponse.success((String)("\u5904\u7406\u6210\u529f\uff01\u6210\u529f\u66f4\u65b0" + (supplierEntities.size() + delEntitys.size()) + "\u6761\u6570\u636e\uff01"));
    }

    @PostMapping(value={"/updateSuplyData"})
    public CommonResponse<String> updateSuplyData(HttpServletRequest request) {
        this.logger.info("\u5f00\u59cb\u6267\u884c\u6570\u636e\u540c\u6b65");
        String upDate = this.getUpDate(request);
        CommonResponse listCommonResponse = this.proSupplierApi.selectByUpDate(upDate);
        this.logger.info("proSupplierApi\u63a5\u53e3\u8c03\u7528\u7ed3\u675f\uff01");
        if (!listCommonResponse.isSuccess()) {
            this.logger.info("\u67e5\u8be2\u6570\u636e\u5931\u8d25!");
            return CommonResponse.error((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
        }
        if (listCommonResponse.getData() == null || ((List)listCommonResponse.getData()).size() == 0) {
            this.logger.info("\u6570\u636e\u65e0\u66f4\u65b0!");
            return CommonResponse.success((String)"\u6570\u636e\u65e0\u66f4\u65b0\uff01");
        }
        List newData = (List)listCommonResponse.getData();
        this.logger.info("\u83b7\u53d6\u5230\u7684\u6570\u636e\u96c6\u957f\u5ea6\u4e3a:" + newData.size());
        List<SupplierEntity> supplierEntities = BeanMapper.mapList((Iterable)newData, SupplierEntity.class);
        Stream<SupplierEntity> delEntityStream = supplierEntities.stream().filter(item -> item.getDr() == 1);
        ArrayList resIds = new ArrayList();
        List<SupplierEntity> delEntitys = delEntityStream.collect(Collectors.toList());
        delEntitys.forEach(item -> resIds.add(item.getId()));
        this.logger.info("\u6267\u884c\u5220\u9664\u7684\u6570\u636e\u6761\u6570\uff1a" + resIds.size());
        if (resIds.size() > 0) {
            boolean b = this.supplierService.removeByIds(resIds);
            this.logger.info("\u6267\u884c\u5220\u9664\u7ed3\u679c\uff1a" + b);
        }
        Stream<SupplierEntity> entityStream = supplierEntities.stream().filter(item -> item.getDr() == 0);
        supplierEntities = entityStream.collect(Collectors.toList());
        List suplyIds = supplierEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", suplyIds);
        List list = this.supplierService.list((Wrapper)wrapper);
        HashMap versionMap = new HashMap();
        list.forEach(item -> versionMap.put(item.getId(), item.getVersion()));
        supplierEntities.forEach(item -> item.setVersion(null == versionMap.get(item.getId()) ? item.getVersion() : (Integer)versionMap.get(item.getId())));
        this.logger.info("\u6267\u884c\u66f4\u65b0\u7684\u6570\u636e\u6761\u6570\uff1a" + supplierEntities.size());
        if (supplierEntities.size() > 0) {
            boolean b1 = this.supplierService.saveOrUpdateBatch(supplierEntities, supplierEntities.size(), false);
            this.logger.info("\u6267\u884c\u66f4\u65b0\u7ed3\u679c\uff1a" + b1);
        }
        this.logger.info("\u5904\u7406\u6210\u529f\uff01\u6210\u529f\u66f4\u65b0" + (supplierEntities.size() + delEntitys.size()) + "\u6761\u6570\u636e\uff01");
        return CommonResponse.success((String)("\u5904\u7406\u6210\u529f\uff01\u6210\u529f\u66f4\u65b0" + (supplierEntities.size() + delEntitys.size()) + "\u6761\u6570\u636e\uff01"));
    }

    private String getUpDate(HttpServletRequest request) {
        Integer day = 7;
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        JSONArray parameters = json.getJSONObject(0).getJSONArray("parameters");
        for (int i = 0; i < parameters.size(); ++i) {
            JSONObject obj = parameters.getJSONObject(i);
            String property = (String)obj.get((Object)"property");
            if (!"day".equalsIgnoreCase(property)) continue;
            day = obj.getInteger("value");
        }
        Date now = new Date();
        String date = com.ejianc.business.contractbase.util.DateUtil.addDay(now, -day.intValue());
        return date;
    }
}

