package com.ejianc.business.contractbase.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.entity.TemplDetailExportSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.entity.TemplateEntity;
import com.ejianc.business.contractbase.service.ITemplDetailExportSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.vo.tempDetail.TemplDetailExportSettingVO;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2022/11/8 10:55
 */
@RestController
@RequestMapping(value = "/templDetail/")
public class TemplDetailExportSettingController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITemplDetailExportSettingService service;

    @Autowired
    private IMdClassApi mdClassApi;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private ITemplateCategoryService templateCategoryService;

    @Autowired
    private ITemplateService templateService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    private static final String EMPTY_EXPORT_PARAM_NAME = "P-W4AGu40184";

    @PostMapping(value = "saveOrUpdate")
    public CommonResponse<String> saveOrUpdate(@RequestBody List<TemplDetailExportSettingVO> vos) {
        service.saveOrUpdateVos(vos);
        return CommonResponse.success("操作成功！");
    }

    @GetMapping(value = "getByTemplateId")
    public CommonResponse<List<TemplDetailExportSettingVO>> getByTemplateId(@RequestParam(required = false) Long categoryId,
                                                                            @RequestParam(required = false)  Long templateId) {
        List<TemplDetailExportSettingVO> resp = new ArrayList<>();
        if(null == categoryId && null == templateId) {
            return CommonResponse.success(resp);
        }

        // 子表为空是否导出系统参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(EMPTY_EXPORT_PARAM_NAME);
        // 默认子表为空时也导出
        Boolean emptyExportFlag = true;
        if (response.isSuccess() && response.getData() != null && "0".equals(response.getData().getValueData())) {
            emptyExportFlag = false;
        }

        TemplateCategoryEntity categoryEntity = null;
        List<TemplDetailExportSettingEntity> detailList = null;

        if(null != categoryId) {
            QueryWrapper<TemplDetailExportSettingEntity> query = new QueryWrapper<>();
            query.eq("category_id", categoryId);
            query.isNull("template_id");
            detailList = service.list(query);
            categoryEntity = templateCategoryService.getById(categoryId);
            if (null == categoryEntity){
                return CommonResponse.error("请点击模板-更多设置合同清单！");
            }
        } else {
            QueryWrapper<TemplDetailExportSettingEntity> query = new QueryWrapper<>();
            query.eq("template_id", templateId);
            detailList = service.list(query);

            TemplateEntity templateEntity = templateService.selectById(templateId);
            if (templateCategoryService.getTenderFlag(templateEntity.getBillTypeCode())){
                QueryWrapper<TemplateCategoryEntity> queryTemplateCategory = new QueryWrapper<>();
                queryTemplateCategory.eq("bill_type_code", templateEntity.getBillTypeCode());
                categoryEntity = templateCategoryService.getOne(queryTemplateCategory);
            }else {
                categoryEntity = templateCategoryService.getOneByTemplateId(templateId);
            }
        }

        if(CollectionUtils.isNotEmpty(detailList)) {
            Map<String, TemplDetailExportSettingVO> detailIdMap = detailList.stream().collect(Collectors.
                    toMap(item -> item.getBelongEntityId().toString(), item -> BeanMapper. map(item, TemplDetailExportSettingVO.class)));
            CommonResponse<List<MdClassVO>> classResp = mdClassApi.findAllByParentEntityId(detailList.get(0).getMainEntityId());
            if(!classResp.isSuccess()) {
                logger.error("获取主实体【id-{}】对应子实体元数据信息失败:{}", detailList.get(0).getMainEntityId(), JSONObject.toJSONString(classResp));
                return CommonResponse.error("获取单据类型对应子实体元数据信息失败！");
            }
            List<MdClassVO> mdSubEntityList = classResp.getData();
            for(MdClassVO sub : mdSubEntityList) {
                if(detailIdMap.containsKey(sub.getId().toString())) {
                    resp.add(detailIdMap.get(sub.getId().toString()));
                } else {
                    resp.add(generateTemplDetail(sub, categoryEntity, templateId, emptyExportFlag));
                }
            }

        } else {
            CommonResponse<MdReferVO> mdReferResp = billTypeApi.queryMetadataByBillType(categoryEntity.getBillTypeCode());
            if(!mdReferResp.isSuccess()) {
                logger.error("根据模板单据类型-{}获取元数据信息失败:{}", categoryEntity.getBillTypeCode(), JSONObject.toJSONString(mdReferResp));
                return CommonResponse.error("根据模板单据类型获取元数据信息失败！");
            }
            MdReferVO mdReferVO = mdReferResp.getData();
            CommonResponse<List<MdClassVO>> classResp = mdClassApi.findAllByParentEntityId(mdReferVO.getMetadataId());
            if(!classResp.isSuccess()) {
                logger.error("获取主实体【id-{}】对应子实体元数据信息失败:{}", mdReferVO.getMetadataId(), JSONObject.toJSONString(classResp));
                return CommonResponse.error("获取单据类型对应子实体元数据信息失败！");
            }
            for(MdClassVO sub : classResp.getData()) {
                resp.add(generateTemplDetail(sub, categoryEntity, templateId, emptyExportFlag));
            }
        }

        return CommonResponse.success(resp);
    }

    @PostMapping(value = "delDetailExportSetting")
    public CommonResponse<String> delDetailExportSetting(@RequestBody TemplDetailExportSettingVO exportSettingVO) {
        service.delByTemplateId(exportSettingVO.getTemplateId());
        return CommonResponse.success("操作成功！");
    }

    private TemplDetailExportSettingVO generateTemplDetail(MdClassVO sub, TemplateCategoryEntity category, Long templateId, Boolean emptyExportFlag) {
        TemplDetailExportSettingVO vo = new TemplDetailExportSettingVO();
        vo.setBelongEntityId(sub.getId());
        vo.setMainEntityId(sub.getParentId());
        vo.setBelongProjectId(sub.getProjectId());
        vo.setTableName(sub.getTableName());
        vo.setBillTypeCode(category.getBillTypeCode());
        vo.setEmptyExportFlag(emptyExportFlag);

        vo.setBelongOrgId(category.getBelongOrgId());
        vo.setBelongOrgCode(category.getBelongOrgCode());
        vo.setBelongOrgName(category.getBelongOrgName());
        vo.setDetailName(sub.getDisplayName());
        vo.setDetailSequence(0);
        vo.setMainAttrName(sub.getMainAttributeField());
        vo.setCategoryId(category.getId());
        vo.setTemplateId(templateId);
        //默认启用
        vo.setDetailStatus(true);
        vo.setRowState("add");
        vo.setId(IdWorker.getId());

        //TODO  系统默认导出模板文件Id

        return vo;
    }

}
