package com.ejianc.business.contractbase.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.enums.MaterialContentEnum;
import com.ejianc.business.contractbase.service.IClauseSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author:刘家乐
 * @version: 1
 * @document:
 */
@RestController
@RequestMapping("templateCategoryController")
public class TemplateCategoryController {
    /**此处需要根据实际修改*/
    private static final String BILL_CODE = "TEMPLATE_CATEGORY";
    private static final String BILL_TYPE_CODE = "BT211109000000001";

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ITemplateCategoryService service;
    @Autowired
    IClauseSettingService  clauseSettingService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;


    /**
     * 查询接口
     * @return p
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param){
        param.getParams().put("is_top",new Parameter("eq","0"));
        param.getOrderMap().put("sequence","asc");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        List<TemplateCategoryEntity> categoryEntityList = service.queryList(param, false);
        List<TemplateCategoryVO> categoryVOList = BeanMapper.mapList(categoryEntityList, TemplateCategoryVO.class);
        for (TemplateCategoryVO e :categoryVOList){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("pid",new Parameter("eq",e.getId()));
            queryParam.getOrderMap().put("sequence","asc");

            List<TemplateCategoryEntity> entityLists = service.queryList(queryParam);
            List<TemplateCategoryVO> categoryVos =
                    BeanMapper.mapList(entityLists, TemplateCategoryVO.class);
            if (categoryVos.isEmpty()){
                e.setChildren(null);
            }else {
                e.setChildren(categoryVos);
            }
        }

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records",categoryVOList);
        return CommonResponse.success("查询成功！", jsonObject);
    }


    /**
     * 查询接口
     * @return p
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TemplateCategoryVO>> pageList(@RequestBody QueryParam param){
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        IPage<TemplateCategoryEntity> page = service.queryPage(param, false);
        IPage<TemplateCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemplateCategoryVO.class));

        return CommonResponse.success("查询成功！", pageData);
    }


    /**
     * 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemplateCategoryVO> saveOrUpdate(@RequestBody TemplateCategoryVO saveorUpdateVO){
        TemplateCategoryEntity entity =
                BeanMapper.map(saveorUpdateVO, TemplateCategoryEntity.class);
        //新增分类标识
        Boolean insertFlag = false;
        //新的分类名称
        String newCategoryName = null;

        if(null == entity.getId()) {
            insertFlag = true;
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()){
                entity.setId(IdWorker.getId());
                if (1 == entity.getIsTop()){
                    TemplateCategoryEntity parent = service.selectById(entity.getPid());
                    //下级
                    entity.setInnerCode(parent.getInnerCode() + "|" + entity.getId());
                    entity.setCategoryProperty(parent.getCategoryProperty());
                    entity.setBillTypeCode(parent.getBillTypeCode());
                }else {
                    //顶级
                    if (service.checkProperty(entity.getCategoryProperty())){
                        entity.setInnerCode(entity.getId().toString());
                    }else {
                        return CommonResponse.error("当前分类属性已存在");
                    }

                }
                entity.setCode(billCode.getData());
                entity.setTenantId(InvocationInfoProxy.getTenantid());
            }else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            TemplateCategoryEntity beforeEntity = service.selectById(entity.getId());
            //如果分类名称被修改（在条款那里更新分类名称）
            if (null != beforeEntity && !beforeEntity.getCategoryName().equals(saveorUpdateVO.getCategoryName())){
                newCategoryName = saveorUpdateVO.getCategoryName();
            }

            if(null == entity.getBelongOrgId()) {
                entity.setBelongOrgCode(beforeEntity.getBelongOrgCode());
                entity.setBelongOrgId(beforeEntity.getBelongOrgId());
                entity.setBelongOrgId(beforeEntity.getBelongOrgId());
            }
        }

        if(null != saveorUpdateVO.getBelongOrgId()) {
            CommonResponse<OrgVO> orgResp = orgApi.getOneById(saveorUpdateVO.getBelongOrgId());
            if(!orgResp.isSuccess()) {
                throw new BusinessException("保存失败，获取组织信息失败！");
            }
            entity.setBelongOrgInnerCode(orgResp.getData().getInnerCode());
        }

        service.saveOrUpdate(entity,false);
        //调用方法 判断全分类可用的条款，在关系表中添加一条数据
        clauseSettingService.updateClauseByCategory(entity, insertFlag, newCategoryName);
        TemplateCategoryVO vo = BeanMapper.map(entity, TemplateCategoryVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    /**
     * 修改名称和排序
     * @return TemplateCategoryVO
     */
    @RequestMapping(value = "/update",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemplateCategoryVO> update(@RequestBody TemplateCategoryVO t){
        TemplateCategoryEntity templateCategoryEntity = service.selectById(t.getId());
        templateCategoryEntity.setCategoryName(t.getCategoryName());
        templateCategoryEntity.setSequence(t.getSequence());
        templateCategoryEntity.setContractPropertyId(t.getContractPropertyId());
        templateCategoryEntity.setContractPropertyCode(t.getContractPropertyCode());
        templateCategoryEntity.setContractPropertyName(t.getContractPropertyName());
        service.saveOrUpdate(templateCategoryEntity,false);
        TemplateCategoryVO vo = BeanMapper.map(templateCategoryEntity, TemplateCategoryVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @RequestMapping(value = "/updateEnableStatus",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemplateCategoryVO> updateEnableStatus(@RequestBody TemplateCategoryVO categoryVO){
        return service.updateEnableStatus(categoryVO);
    }
    /**
     * 查询所有合同类型 返回集合树 合同模板处 左侧树用
     * @return 合同类型
     */
    @RequestMapping(value = "/queryAll", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TemplateCategoryVO>> queryAll(){
        return service.queryTree();
    }
    /**
     * 删除 对应模板分类
     * @return TemplateCategoryVO
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemplateCategoryVO> vos) {
        for(TemplateCategoryVO vo : vos) {
            CommonResponse<String> resp = billTypeApi.checkQuote(BILL_TYPE_CODE, vo.getId());
            logger.info("合同分类【id-{}】，【BILL_TYPE_CODE-{}】校验被下游单据引用结果：{}", vo.getId(), BILL_TYPE_CODE, JSONObject.toJSONString(resp));
            //如果分类被下游引用，则不允许删除，则返回错误信息
            if(!resp.isSuccess()) {
                logger.info("合同分类被下游引用，不能删除");
                return CommonResponse.error("合同分类被下游引用，不能删除！");
            }
        }
        service.removeRelationByCategory(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @return List<TemplateCategoryVO> 返回同级的合同分类
     */
    @RequestMapping(value = "/querySameLevel", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<List<TemplateCategoryVO>> querySameLevel(@RequestParam("categoryId") String categoryId,
                                                            @RequestParam(required = false) String range){
        return service.querySameLevel(categoryId,range);
    }

    /**
     * 新增子级 查询所有父级+1
     */
    @ResponseBody
    @RequestMapping(value = "/getCategoryParent", method = RequestMethod.GET)
    public CommonResponse<IPage<TemplateCategoryVO>> getCategoryParent(@RequestParam("pageNumber") Integer pageNumber, @RequestParam("pageSize")  Integer pageSize){
        QueryParam param = new QueryParam();
//        数据租户隔离
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        return service.getCategoryParent(param);
    }

    @PostMapping(value = "/wholeCategoryTree")
    public CommonResponse<JSONObject> wholeCategoryTree(@RequestBody String condition) {
        JSONObject data = new JSONObject();
        data.put("data", categoryTree(condition));
        return CommonResponse.success(data);
    }

    /**
     * （包含父级 子级）
     * @return 返回所有分类树
     */
    @GetMapping("/categoryTree")
    public List<Map<String, Object>> categoryTree(@RequestParam(value = "condition", required = false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("enable_status",new Parameter("eq","1"));
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getFuzzyFields().add("categoryName");

        if(StringUtils.isNotBlank(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("categoryId")){
                //类型转换 拿到categoryId
                Long categoryId = Long.parseLong(conditionMap.get("categoryId").toString());
                TemplateCategoryEntity category = service.selectById(categoryId);
                if (category!=null){
                    if(null != conditionMap.get("only")) {
                        queryParam.getParams().put("id",new Parameter(QueryParam.EQ, categoryId));
                    } else {
                        //传入顶级 id 查询本下
                        queryParam.getParams().put("categoryProperty",new Parameter(QueryParam.EQ,category.getCategoryProperty()));
                    }
                }
            }
            if(null != conditionMap.get("range")) {
                String range = conditionMap.get("range").toString();
                switch (range) {
                    case "selfOrg":
                        //本级
                        queryParam.getParams().put("belong_org_id",new Parameter("eq",InvocationInfoProxy.getOrgId()));
                        break;
                    case "selfAndBelow":
                        //本下
                        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
                            queryParam.getParams().put("belong_org_id",new Parameter("eq",InvocationInfoProxy.getOrgId()));
                        } else {
                            CommonResponse<List<OrgVO>> orgVOListResp = orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                            if(!orgVOListResp.isSuccess()) {
                                throw new BusinessException("查询失败，获取组织信息失败！");
                            }
                            queryParam.getParams().put("belong_org_id",new Parameter("in", orgVOListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                        }
                        break;
                    case "parents":
                        //父级
                        CommonResponse<List<OrgVO>> orgVOListResp = orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
                        if(!orgVOListResp.isSuccess()) {
                            throw new BusinessException("查询失败，获取组织信息失败！");
                        }
                        queryParam.getParams().put("belong_org_id",new Parameter("in", orgVOListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                        break;
                    default: ;
                }
            }

            if(null != conditionMap.get("categoryProperty")) {
                queryParam.getParams().put("categoryProperty",new Parameter(QueryParam.EQ, conditionMap.get("categoryProperty")));
            } else if(null != conditionMap.get("categoryPropertys")) {
                queryParam.getParams().put("categoryProperty", new Parameter(QueryParam.IN, conditionMap.get("categoryPropertys").toString()));
            }
            if("true".equals(conditionMap.get("noParent"))) {
                //只查询子分类
                queryParam.getParams().put("isTop",new Parameter(QueryParam.EQ, 1));
            }
            if(null != conditionMap.get("isTop")) {
                //只查询子分类
                queryParam.getParams().put("isTop",new Parameter(QueryParam.EQ, conditionMap.get("isTop")));
            }

            if(null != conditionMap.get("searchText")) {
                queryParam.setSearchText(conditionMap.get("searchText").toString());
            }
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("sequence", "asc");
        queryParam.setOrderMap(orderMap);
        List<TemplateCategoryEntity> dataList = service.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;

        //获取供货内容
        CommonResponse<List<DefdocDetailVO>> defdocData = defdocApi.queryDetailListByDefdocCodeList(service.getAllDefDocContent());
        if (!defdocData.isSuccess()){
            logger.error("获取供货内容失败, {}", defdocData.getMsg());
            throw new BusinessException("获取供货内容失败， 请稍后再试");
        }
        List<DefdocDetailVO> defdocDetailVOList = defdocData.getData();
        Map<String, List<DefdocDetailVO>> defdocMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(defdocDetailVOList)){
            logger.info("获取供货内容条数：{}", defdocDetailVOList.size());
            defdocMap = defdocDetailVOList.stream().collect(Collectors.groupingBy(DefdocDetailVO::getParentCode));
        }

        for(TemplateCategoryEntity entity:dataList) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getCategoryName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getPid());
            map.put("isTop", entity.getIsTop());

            map.put("categoryProperty", entity.getCategoryProperty());
            map.put("billTypeCode", entity.getBillTypeCode());
            map.put("contractPropertyCode", entity.getContractPropertyCode());
            map.put("contractPropertyId", entity.getContractPropertyId());
            map.put("contractPropertyName", entity.getContractPropertyName());
            resultMapList.add(map);

            //招标类单独处理
            if (entity.getIsTop().equals(0) && entity.getCategoryProperty().contains("tender")){
                resultMapList.addAll(service.setTenderResultMapList(entity, defdocMap));
            }
        }
        return ResultAsTree.createTreeData(resultMapList);
    }




    /**
     * 根据分类属性 返回合同分类
     * @param categoryProperty 分类属性
     * @return 合同子级list
     */
    @ResponseBody
    @RequestMapping(value = "/queryCategory",method = RequestMethod.GET)
    public CommonResponse<JSONObject> queryCategory(
            @RequestParam(value = "categoryProperty") String categoryProperty
    ){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("categoryProperty",new Parameter(QueryParam.EQ, categoryProperty));
        queryParam.getParams().put("enable_status",new Parameter(QueryParam.EQ, "1"));
        queryParam.getParams().put("is_top",new Parameter(QueryParam.EQ, "1"));
        List<TemplateCategoryEntity> templateCategoryEntities = service.queryList(queryParam, false);
        List<TemplateCategoryVO> templateCategory = BeanMapper.mapList(templateCategoryEntities, TemplateCategoryVO.class);
        JSONObject jsonObject = new JSONObject();
        if (templateCategory.isEmpty()){
            jsonObject.put("data",null);
            return CommonResponse.success(jsonObject);
        }
        List<Map<String, Object>> list =new ArrayList();
        templateCategory.forEach( category->{
            JSONObject o = (JSONObject) JSONObject.toJSON(category);
            o.put("text",category.getCategoryName());
            o.put("value",category.getId());
            list.add(o);
        });
        jsonObject.put("data",list);
        return CommonResponse.success(jsonObject);
    }
}
