package com.ejianc.business.contractbase.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.entity.CommonSNEntity;
import com.ejianc.business.contractbase.service.ICommonSNService;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author CJ
 * @Description:
 * @date 2022/7/7 15:33
 */
@RestController
@RequestMapping
public class CommonSNAPI {

    @Autowired
    private ICommonSNService commonSNService;

    @PostMapping(value = "/api/commonSN/getNext")
    public CommonResponse<String> getNext(@RequestBody CommonSNVO commonSNVO) {
        if(null == commonSNVO) {
            return CommonResponse.error("生成流水号失败，参数为空！");
        }
        if(null == commonSNVO.getTenantId()) {
            return CommonResponse.error("生成流水号失败，租户Id为空");
        }
        if(StringUtils.isBlank(commonSNVO.getSourceType())) {
            return CommonResponse.error("生成流水号失败，业务为空");
        }
        if(StringUtils.isBlank(commonSNVO.getDimension())) {
            return CommonResponse.error("生成流水号失败，流水号依据为空");
        }

        QueryWrapper<CommonSNEntity> query = new QueryWrapper<>();
        query.eq("source_type", commonSNVO.getSourceType());
        query.eq("dimension", commonSNVO.getDimension());
        query.eq("tenant_id", commonSNVO.getTenantId());

        CommonSNEntity curSn = commonSNService.getOne(query);
        if(null == curSn) {
            curSn = BeanMapper.map(commonSNVO, CommonSNEntity.class);
            if(StringUtils.isBlank(commonSNVO.getDimension())) {
                return CommonResponse.error("生成流水号失败，流水号长度为空");
            }
            //新的流水号从1开始
            curSn.setCurSn(1L);
            curSn.setVersion(0);
        } else {
            curSn.setCurSn(curSn.getCurSn()+1);
        }
        boolean rs = commonSNService.saveOrUpdate(curSn, false);
        if(!rs) {
            return CommonResponse.error("生成流水号失败，获取最新流水号失败，请重试！");
        }

        return CommonResponse.success("生成流水号成功！", String.format("%0" + curSn.getSnLength() + "d", curSn.getCurSn()));
    }
}
