package com.ejianc.business.contractbase.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 模板类别API
 *
 * @author CJ
 * @Description: 模板类别API
 * @date 2021/11/25 10:31
 */
@RestController
@RequestMapping
public class TemplateCategoryApi {

    @Autowired
    private ITemplateCategoryService templateCategoryService;

    /**
     * 根据模板分类Id查询模板类别信息
     *
     * @param id 模板Id
     * @return
     */
    @GetMapping(value = "/api/template/queryTmplCategoryById")
    public CommonResponse<TemplateCategoryVO> queryTmplCategoryById(@RequestParam(value = "id") Long id) {
        TemplateCategoryEntity entity = templateCategoryService.selectById(id);
        if(null == entity) {
            return CommonResponse.error("查询失败，未查询到匹配的模板类别信息！");
        }
        return CommonResponse.success("查询成功！", BeanMapper.map(entity, TemplateCategoryVO.class));
    }

    /**
     * 根据分类查询其本身及其子分类
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/api/template/querySelfAndChildById")
    public CommonResponse<List<TemplateCategoryVO>> querySelfAndChildById(@RequestParam(value = "id") Long id) {
        QueryWrapper<TemplateCategoryEntity> query = new QueryWrapper<>();

        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("enable_status", "1");
        query.and(q -> q.eq("id", id).or().eq("pid", id));

        List<TemplateCategoryEntity> list = templateCategoryService.list(query);
        return CommonResponse.success("查询成功！", BeanMapper.mapList(list, TemplateCategoryVO.class));
    }


    //根据id查询到分类编码
    @PostMapping(value = "/api/categoty/selectTemplateCategoriesByIds")
    public CommonResponse<List<TemplateCategoryVO>> selectTemplateCategoriesByIds(@RequestBody List<Long> ids){
        LambdaQueryWrapper<TemplateCategoryEntity> lambda = new LambdaQueryWrapper<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id",new Parameter(QueryParam.IN,ids));
        List<TemplateCategoryEntity> entities = templateCategoryService.queryList(queryParam);
        return CommonResponse.success("查询成功",BeanMapper.mapList(entities,TemplateCategoryVO.class));
    }

}
