package com.ejianc.business.contractbase.cooperative.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.contractbase.cooperative.bean.CooperativeAdjustEntity;
import com.ejianc.business.contractbase.cooperative.service.ICooperativeAdjustService;
import com.ejianc.business.contractbase.cooperative.vo.CooperativeAdjustVO;

/**
 * 协同率调整设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("cooperativeAdjust")
public class CooperativeAdjustController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ICooperativeAdjustService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CooperativeAdjustVO> saveOrUpdate(@RequestBody CooperativeAdjustVO saveOrUpdateVO) {
        if(null!=saveOrUpdateVO.getCooperativeAdjustType()&&0==saveOrUpdateVO.getCooperativeAdjustType()){
            //只能存在一个项目的数据
            LambdaQueryWrapper<CooperativeAdjustEntity> lambda = Wrappers.<CooperativeAdjustEntity>lambdaQuery();
            lambda.eq(CooperativeAdjustEntity::getProjectId, saveOrUpdateVO.getProjectId());
            if(null!=saveOrUpdateVO.getId()&&saveOrUpdateVO.getId()>0){
                lambda.ne(CooperativeAdjustEntity::getId, saveOrUpdateVO.getId());
            }
            List<CooperativeAdjustEntity> entities = service.list(lambda);
            if(CollectionUtils.isNotEmpty(entities)){
                throw new BusinessException("同一个项目不允许存在多条数据!");
            }
        }

        if(null!=saveOrUpdateVO.getCooperativeAdjustType()&&1==saveOrUpdateVO.getCooperativeAdjustType()){
            //只能存在一个项目的数据
            LambdaQueryWrapper<CooperativeAdjustEntity> lambda = Wrappers.<CooperativeAdjustEntity>lambdaQuery();
            lambda.eq(CooperativeAdjustEntity::getSupplierId, saveOrUpdateVO.getSupplierId());
            if(null!=saveOrUpdateVO.getId()&&saveOrUpdateVO.getId()>0){
                lambda.ne(CooperativeAdjustEntity::getId, saveOrUpdateVO.getId());
            }
            List<CooperativeAdjustEntity> entities = service.list(lambda);
            if(CollectionUtils.isNotEmpty(entities)){
                throw new BusinessException("同一个供应商不允许存在多条数据!");
            }
        }
        if(null!=saveOrUpdateVO.getId()){
            saveOrUpdateVO.setCreateUserName(sessionManager.getUserContext().getUserName());
        }else{
            saveOrUpdateVO.setUpdateUserName(sessionManager.getUserContext().getUserName());
        }
    	CooperativeAdjustEntity entity = BeanMapper.map(saveOrUpdateVO, CooperativeAdjustEntity.class);
    	service.saveOrUpdate(entity, false);
    	CooperativeAdjustVO vo = BeanMapper.map(entity, CooperativeAdjustVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CooperativeAdjustVO> queryDetail(Long id) {
    	CooperativeAdjustEntity entity = service.selectById(id);
    	CooperativeAdjustVO vo = BeanMapper.map(entity, CooperativeAdjustVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CooperativeAdjustVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CooperativeAdjustVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CooperativeAdjustVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CooperativeAdjustVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Parameter cooperativeAdjustType = param.getParams().get("cooperativeAdjustType");
        if(null!=cooperativeAdjustType&&"0".equals(cooperativeAdjustType.getValue())){
            List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CooperativeAdjustEntity> page = service.queryPage(param,false);
        IPage<CooperativeAdjustVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CooperativeAdjustVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CooperativeAdjustEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("cooperativeAdjust-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refcooperativeAdjustData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CooperativeAdjustVO>> refcooperativeAdjustData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CooperativeAdjustEntity> page = service.queryPage(param,false);
        IPage<CooperativeAdjustVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CooperativeAdjustVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
