package com.ejianc.business.contractbase.cooperative.mapper;

import com.ejianc.business.contractbase.cooperative.vo.CooperativeRatioVO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.contractbase.cooperative.bean.CooperativeCollectEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 协同数据汇总表
 * 
 * @author generator
 * 
 */
@Mapper
public interface CooperativeCollectMapper extends BaseCrudMapper<CooperativeCollectEntity> {

    @Delete("delete from ejc_conbase_cooperative_collect")
    void delCooperativeCollectAll();

    List<CooperativeCollectEntity> getAllCooperativeData();

    List<CooperativeRatioVO> queryProjectCooperativeRatioBySupplier(@Param("orgIds")List<Long> orgIds, @Param("startDate")String startDate,
                                                               @Param("endDate")String endDate, @Param("projectName")String projectName,
                                                               @Param("minRatio")String minRatio, @Param("maxRatio")String maxRatio,  @Param("orderValue")String orderValue);

    List<CooperativeRatioVO> queryProjectCooperativeRatioByBill(@Param("orgIds")List<Long> orgIds, @Param("startDate")String startDate,
                                                          @Param("endDate")String endDate, @Param("projectName")String projectName,
                                                          @Param("minRatio")String minRatio, @Param("maxRatio")String maxRatio,  @Param("orderValue")String orderValue);

    List<CooperativeRatioVO> querySupplierCooperativeRatioByProject(@Param("orgIds")List<Long> orgIds, @Param("startDate")String startDate,
                                                                    @Param("endDate")String endDate, @Param("supplierName")String supplierName,
                                                                    @Param("minRatio")String minRatio, @Param("maxRatio")String maxRatio,  @Param("orderValue")String orderValue);

    List<CooperativeRatioVO> querySupplierCooperativeRatioByBill(@Param("orgIds")List<Long> orgIds, @Param("startDate")String startDate,
                                                                 @Param("endDate")String endDate, @Param("supplierName")String supplierName,
                                                                 @Param("minRatio")String minRatio, @Param("maxRatio")String maxRatio,  @Param("orderValue")String orderValue);
}
