package com.ejianc.business.contractbase.cooperative.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.cooperative.vo.CooperativeRatioVO;
import com.ejianc.business.contractbase.util.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.contractbase.cooperative.mapper.CooperativeCollectMapper;
import com.ejianc.business.contractbase.cooperative.bean.CooperativeCollectEntity;
import com.ejianc.business.contractbase.cooperative.service.ICooperativeCollectService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 协同数据汇总表
 * 
 * @author generator
 * 
 */
@Service("cooperativeCollectService")
public class CooperativeCollectServiceImpl extends BaseServiceImpl<CooperativeCollectMapper, CooperativeCollectEntity> implements ICooperativeCollectService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Override
    public void initCooperativeCollect() {
        logger.info("---协同率数据初始化开始---");
        //1.先执行全删除操作
        logger.info("---数据全删除操作开始---");
        baseMapper.delCooperativeCollectAll();
        //2.从各业务中查得所需数据
        logger.info("---数据查询操作开始---");
        List<CooperativeCollectEntity> cooperativeCollectEntityList = baseMapper.getAllCooperativeData();
        logger.info("---查到所有协同数据信息--->{}", JSONObject.toJSONString(cooperativeCollectEntityList));
        super.saveOrUpdateBatch(cooperativeCollectEntityList, cooperativeCollectEntityList.size());
        logger.info("---协同率数据初始化结束，插入数据：{}条", cooperativeCollectEntityList.size());
    }

    @Override
    public IPage<CooperativeRatioVO> getProjectCooperativeRatio(QueryParam param) {
        logger.info("查询协同率，查询参数：{}", JSONObject.toJSONString(param));
        Map<String, Parameter> paramMap = param.getParams();

        //组织
        Long orgId;
        if (!paramMap.containsKey("orgId") ) {
            orgId = InvocationInfoProxy.getOrgId();
        }else {
            orgId = Long.valueOf(paramMap.get("orgId").getValue().toString());
        }
        List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        //单据创建时间区间
        String startDate = paramMap.containsKey("startDate") ? paramMap.get("startDate").getValue().toString() : null;;
        String endDate = paramMap.containsKey("endDate") ? paramMap.get("endDate").getValue().toString() : null;

        //项目名称
        String projectName = paramMap.containsKey("projectName") ? paramMap.get("projectName").getValue().toString() : null;

        //协同率区间
        String minRatio = paramMap.containsKey("minRatio") ? paramMap.get("minRatio").getValue().toString() : null;;
        String maxRatio = paramMap.containsKey("maxRatio") ? paramMap.get("maxRatio").getValue().toString() : null;

        // 排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        String orderValue = orderMap.get("orderValue") != null ? orderMap.get("orderValue").toString() : "";

        // 查询类型
        if (!paramMap.containsKey("queryType")){
            throw new BusinessException("查询类型不能为空");
        }
        String queryType = paramMap.get("queryType").getValue().toString();

        //测试数据
//        orgIds = Arrays.asList(1478271230439067649L, 1247777316689256450L);
//        startDate = "2022-01-01";
//        endDate = "2023-10-01";
//        projectName = "施工合同专用项目";
//        minRatio = "50";
//        maxRatio = "70";
//        orderValue = "desc";
        List<CooperativeRatioVO> cooperativeCollectVOList = new ArrayList<>();
        if ("supplier".equals(queryType)){
            //按合作供应商统计
            cooperativeCollectVOList = baseMapper.queryProjectCooperativeRatioBySupplier(orgIds, startDate, endDate, projectName, minRatio, maxRatio, orderValue);
        }else {
            //按全单据统计
            cooperativeCollectVOList = baseMapper.queryProjectCooperativeRatioByBill(orgIds, startDate, endDate, projectName, minRatio, maxRatio, orderValue);
        }
        logger.info("查出数据：{}", JSONObject.toJSONString(cooperativeCollectVOList));

        IPage<CooperativeRatioVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), cooperativeCollectVOList.size());
        // 进行分页处理
        pageDate.setRecords(cooperativeCollectVOList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                .limit(param.getPageSize()).collect(Collectors.toList()));

        return pageDate;
    }

    @Override
    public IPage<CooperativeRatioVO> getSupplierCooperativeRatio(QueryParam param) {
        logger.info("查询协同率，查询参数：{}", JSONObject.toJSONString(param));
        Map<String, Parameter> paramMap = param.getParams();

        //组织
        Long orgId;
        if (!paramMap.containsKey("orgId") ) {
            orgId = InvocationInfoProxy.getOrgId();
        }else {
            orgId = Long.valueOf(paramMap.get("orgId").getValue().toString());
        }
        List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        //单据创建时间区间
        String startDate = paramMap.containsKey("startDate") ? paramMap.get("startDate").getValue().toString() : null;;
        String endDate = paramMap.containsKey("endDate") ? paramMap.get("endDate").getValue().toString() : null;

        //项目名称
        String supplierName = paramMap.containsKey("projectName") ? paramMap.get("projectName").getValue().toString() : null;

        //协同率区间
        String minRatio = paramMap.containsKey("minRatio") ? paramMap.get("minRatio").getValue().toString() : null;;
        String maxRatio = paramMap.containsKey("maxRatio") ? paramMap.get("maxRatio").getValue().toString() : null;

        // 排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        String orderValue = orderMap.get("orderValue") != null ? orderMap.get("orderValue").toString() : "";

        // 查询类型
        if (!paramMap.containsKey("queryType")){
            throw new BusinessException("查询类型不能为空");
        }
        String queryType = paramMap.get("queryType").getValue().toString();

        //测试数据
//        orgIds = Arrays.asList(1247777316689256450L, 1465209097994674178L,1471423173860179970L );
//        startDate = "2022-01-01";
//        endDate = "2023-10-01";
//        supplierName = "云南建投供应商测试";
//        minRatio = "50";
//        maxRatio = "70";
//        orderValue = "desc";
        List<CooperativeRatioVO> cooperativeCollectVOList = new ArrayList<>();
        if ("project".equals(queryType)){
            //按合作项目统计
            cooperativeCollectVOList = baseMapper.querySupplierCooperativeRatioByProject(orgIds, startDate, endDate, supplierName, minRatio, maxRatio, orderValue);
        }else {
            //按单据统计
            cooperativeCollectVOList = baseMapper.querySupplierCooperativeRatioByBill(orgIds, startDate, endDate, supplierName, minRatio, maxRatio, orderValue);
        }
        logger.info("查出数据：{}", JSONObject.toJSONString(cooperativeCollectVOList));

        IPage<CooperativeRatioVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), cooperativeCollectVOList.size());
        // 进行分页处理
        pageDate.setRecords(cooperativeCollectVOList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                .limit(param.getPageSize()).collect(Collectors.toList()));

        return pageDate;
    }


}
