package com.ejianc.business.contractbase.filing.service.impl;

import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.filing.entity.ContractFilingEntity;
import com.ejianc.business.contractbase.filing.entity.FilingTypeEntity;
import com.ejianc.business.contractbase.filing.enums.FilingBillTypeEnum;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.filing.mapper.ContractFilingMapper;
import com.ejianc.business.contractbase.filing.service.IContractFilingService;
import com.ejianc.business.contractbase.filing.service.IFilingTypeService;
import com.ejianc.business.contractbase.filing.vo.ContractFilingVO;
import com.ejianc.business.contractbase.filing.vo.FilingTypeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import io.seata.spring.annotation.GlobalTransactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Service("contractFilingService")
public class ContractFilingServiceImpl extends BaseServiceImpl<ContractFilingMapper, ContractFilingEntity>
        implements IContractFilingService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IFilingTypeService filingTypeService;

    @Override
    @GlobalTransactional(name="ContractFilingServiceImpl_updateFilingStatus", rollbackFor = Exception.class)
    public void updateFilingStatus(ContractFilingEntity entity, Integer status,Integer refStatus) {
        logger.error("修改归档 入参:{}",JSONObject.toJSONString(entity));
        String[] billTypeCodes = entity.getUpdateBillType().split(",");
        CommonResponse<MdReferVO> mdRefResp = null;
        String tableName = null, projectName = null;
        for(String billType : billTypeCodes) {
            //1 根据单据类型编码查询到对应的元数据信息
            mdRefResp = billTypeApi.queryMetadataByBillType(billType);
            if(!mdRefResp.isSuccess()) {
                logger.error("更新单据归档状态失败, 归档单据-{}，查询元数据结果-{}", JSONObject.toJSONString(entity), JSONObject.toJSONString(mdRefResp));
                throw new BusinessException("保存失败，更新单据归档状态失败！");
            }
            //2 根据元数据信息找到对应实体信息，
            tableName = mdRefResp.getData().getTableName();
            projectName = mdRefResp.getData().getProjectName();
            logger.info("x项目名称{}",projectName);
            //3 从元数据获取到表名， 然后更单据归档状态
            Map<String, Object> params = new HashMap<>();
            params.put("tableName",tableName);
            params.put("billId",entity.getSourceId());
            Map fields = new HashMap();
            Map tableNames = new HashMap();
            if (entity.getFilingTypeName().indexOf("变更")>0){
                tableNames.put("filingStatus","change_filing_status");
            }else {
                tableNames.put("filingStatus","filing_status");
            }
            fields.put("filingStatus",status);
            tableNames.put("filingRef","filing_ref");
            fields.put("filingRef",refStatus);
            params.put("fields",fields);
            params.put("tableNames",tableNames);
            String authority = null;
            //获取请求头
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
            logger.info("获取的请求头 authority：{}", request.getHeader("authority"));
            if (StringUtils.isNotBlank(request.getHeader("authority"))) {
                authority = request.getHeader("authority");
            }
            String url = BaseHost+projectName+"/commonUpdate/updateFilingStatus";
            String response = HttpUtil.createRequest(Method.POST, url)
                    .header("authority", authority)
                    .body(JSON.toJSONString(params))
                    .timeout(10000)
                    .execute().body();
            Assert.hasLength(response, "归档修改状态请求失败，返回结果为空！");
            logger.info("调用业务系统url-{}，param-{}，结果：{}", url, JSON.toJSONString(params, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue), response);

//            //TODO 如果是已归档，则向归档文件替换单据的源文件
//            if(FilingStatusEnum.已归档.getTypeCode().equals(status)) {
//                attachmentApi.copyFile(entity.getFileId().toString(), entity.getSourceId().toString(), "", "" ,true);
//            }

            CommonResponse<String> commonResponse = JSON.parseObject(response, CommonResponse.class);
            if (!commonResponse.isSuccess()) {
                logger.error("修改归档状态，请求「成功」，返回结果「失败」：{}！", commonResponse.getMsg());
                throw new BusinessException("修改归档状态，请求「成功」，返回结果「失败」：" + commonResponse.getMsg());
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractFilingVO saveOrUpdateFilingVO(ContractFilingVO saveorUpdateVO) {
        ContractFilingEntity entity = BeanMapper.map(saveorUpdateVO, ContractFilingEntity.class);
        if (null == entity.getId()) {
            //校验当前合同是否可以添加
            QueryWrapper<ContractFilingEntity> query = new QueryWrapper<>();
            query.eq("contract_id", entity.getContractId());
            query.eq("dr", 0);
            int count = super.count(query);
            if (count > 0) {
                logger.info("当前{}合同已存在生效的归档单 ", entity.getContractName());
                throw new BusinessException("一个合同下只能有一个归档单， 请更换合同！");
            }

            logger.info("测试单{}", entity.getFilingTypeInnerCode());

            logger.info("获取编码请求参数 --BILL_CODE{}/n --InvocationInfoProxy.getTenantid()--{}/n saveorUpdateVO--{}",
                    FilingBillTypeEnum.getByName(entity.getFilingTypeInnerCode()).getTypeCode(),InvocationInfoProxy.getTenantid(),JSONObject.toJSONString(saveorUpdateVO));
            BillCodeParam billCodeParam = BillCodeParam.build(FilingBillTypeEnum.getByName(entity.getFilingTypeInnerCode()).getTypeCode(), InvocationInfoProxy.getTenantid(), saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                logger.info("获取编码请求成功 结果失败--{}",JSONObject.toJSONString(billCode));
                throw new BusinessException("网络错误 获取编码失败！");
            }
            entity.setBillCode(billCode.getData());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            //设置同步归档状态
            updateFilingStatus(entity, FilingStatusEnum.归档中.getTypeCode(),1);
        }

        super.saveOrUpdate(entity, false);

        return BeanMapper.map(entity, ContractFilingVO.class);
    }

    @Override
    public JSONObject queryContractDetail(String contractId, String contractSubType) {
        String authority = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractSubType", new Parameter(QueryParam.EQ, contractSubType));
        List<FilingTypeEntity> typeEntityList = filingTypeService.queryList(queryParam);
        if (CollectionUtils.isEmpty(typeEntityList) || null == typeEntityList.get(0)){
            throw new BusinessException("获取归档类型失败，请检查参数-contractSubType！");
        }
        FilingTypeEntity typeEntity = typeEntityList.get(0);
        logger.info("获取归档信息成功：typeEntity：{}", JSONObject.toJSONString(typeEntity));
        String columns = typeEntity.getQueryColumns();
        String databaseName = typeEntity.getQueryDatabaseName();
        String tableName = typeEntity.getQueryTableName();
        String parameter = "id=" + contractId;

        //获取请求头
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
        logger.info("获取的请求头 authority：{}", request.getHeader("authority"));
        if (StringUtils.isNotBlank(request.getHeader("authority"))) {
            authority = request.getHeader("authority");
        }
        Map<String, Object> params = new HashMap<>();
        params.put("columns", columns);
        params.put("databaseName", databaseName);
        params.put("parameter", parameter);
        params.put("tableName", tableName);
        params.put("projectName", typeEntity.getQueryProjectName());

        logger.info("查询参数 params：{}", JSONObject.toJSONString(params));
        String url = BaseHost + typeEntity.getQueryProjectName() + "/pubQuery/queryBillMap";
        String response = HttpUtil.createRequest(Method.POST, url)
                .header("authority", authority)
                .body(JSON.toJSONString(params))
                .timeout(10000)
                .execute().body();
        Assert.hasLength(response, "合同请求失败，返回结果为空！");
        logger.info("调用业务系统url-{}，param-{}，结果：{}", url, JSON.toJSONString(params, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue), response);
        CommonResponse<JSONObject> commonResponse = JSON.parseObject(response, CommonResponse.class);
        if (!commonResponse.isSuccess()) {
            logger.error("请求「成功」，返回结果「失败」：{}！", commonResponse);
            throw new BusinessException("请求「成功」，返回结果「失败」：" + commonResponse);
        }

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("record", commonResponse.getData().get("data"));
        jsonObject.put("filingType", BeanMapper.map(typeEntity, FilingTypeVO.class));

        return jsonObject;
    }

    public void queryFilingDataRef(){

    }





}