package com.ejianc.business.contractbase.home.mapper;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.contractbase.home.vo.CostDetailVO;
import com.ejianc.business.contractbase.home.vo.TargetCostDetailVO;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 门户首页 Mapper 接口
 * </p>
 *
 * @author yqls
 * @since 2022-04-28
 */
@Mapper
public interface HomePortalMapper extends BaseCrudMapper<ContractPoolEntity> {

    List<Long> querySubjectOrg(String subjectName);

    List<CostDetailVO> queryCostByProjectId(Long projectId);

    Map<String,Object> queryTargetCostByProjectId(Long projectId);

    List<ProjectPoolSetVO> queryProjectIdByOrgIds(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<TargetCostDetailVO> queryTargetCostDetailByIds(@Param("targetIds") List<Long> targetIds);

    List<TargetCostDetailVO> queryProCostDetailByProjectIds(@Param("projectIds") List<Long> projectIds);
}
