package com.ejianc.business.contractbase.pool.contractpool.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * 合同基本信息预览控制器
 *
 * @author CJ
 * @Description: 合同基本信息预览控制器
 * @date 2022/6/3 13:22
 */
@RestController
@RequestMapping(value = "/contractPreview/")
public class ContractPreviewController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IMdApi mdApi;

    @Autowired
    private IMdAttributeApi mdAttributeApi;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @GetMapping(value = "queryDetail")
    public CommonResponse<JSONObject> queryDetail(@RequestParam Long id,
                                                  @RequestParam String billType,
                                                  HttpServletRequest request) throws Exception {
        JSONObject resp = new JSONObject();
        String authority = request.getHeader("authority");
        //查询单据详情
        //根据单据类型找到单据类型对应的元数据Id
        CommonResponse<BillTypeVO> billTypeVo = billTypeApi.getByCode(billType);
        if(!billTypeVo.isSuccess()) {
            logger.error("查询打印数据详情失败，获取对应单据类型【code: {}】信息失败！", billType);
            return CommonResponse.error("查询合同数据详情失败，获取对应单据类型信息失败！");
        }

        //根据元数据Id查询对应实体信息
        CommonResponse<MdReferVO> mdResp = mdApi.queryMetadataById(billTypeVo.getData().getMetadataId());
        if(!mdResp.isSuccess()) {
            logger.error("查询打印数据详情失败，根据元数据Id【{}】查询元数据信息失败！", billTypeVo.getData().getMetadataId());
            return CommonResponse.error("查询合同数据详情失败，获取对应单据元数据信息失败！");
        }
        MdReferVO mdReferVO = mdResp.getData();

        String url = BaseHost + mdReferVO.getProjectName() + "/commonstate/queryBillDetail";
        Map<String, String> params = new HashMap<>();
        Map<String, String> headers = new HashMap<>();

        params.put("billId", id.toString());
        params.put("tableName", mdReferVO.getTableName());
        params.put("metadataId", mdReferVO.getMetadataId().toString());

        headers.put("content-type", "application/json;charset=UTF-8");
        headers.put("authority", authority);

        logger.info("发送请求url-{},参数-{},header-{} 获取单据详情", url, JSONObject.toJSONString(params), JSONObject.toJSONString(headers));
        String detailReqStr = HttpTookit.postByJson(url, JSONObject.toJSONString(params), headers, 10000, 10000);
        logger.info("获取单据详情结果：{}", detailReqStr);

        CommonResponse<JSONObject> detailResp = JSONObject.parseObject(detailReqStr, CommonResponse.class);
        if(!detailResp.isSuccess()) {
            logger.error("查询打印数据详情失败, 发送请求url-{},参数-{},header-{} 获取单据详情失败", url, JSONObject.toJSONString(params), JSONObject.toJSONString(headers));
            return CommonResponse.error("查询打印数据详情失败, 查询单据详情失败！");
        }

        resp = JSONObject.parseObject(JSONObject.toJSONString(detailResp.getData()));

        //查询二维码字段信息
        CommonResponse<MdAttributeVO> attrResp = mdAttributeApi.queryAttrInfoByAttName(mdReferVO.getMetadataId(), "qrCode");
        if(!attrResp.isSuccess()) {
            logger.error("查询打印数据详情失败, 根据元数据Id-{},查询字段-【qrCode】信息失败！",mdReferVO.getMetadataId().toString());
            return CommonResponse.error("查询打印数据详情失败, 获取单据属性信息失败！");
        }

        if(null == attrResp.getData() || StringUtils.isBlank(attrResp.getData().getDataFormat())) {
            logger.error("查询打印数据详情失败, 根据元数据Id-{},查询字段-【qrCode】信息失败！",mdReferVO.getMetadataId().toString());
            return CommonResponse.error("查询打印数据详情失败, 获取单据属性信息失败！");
        }

        resp.put("billStateName", BillStateEnum.getEnumByStateCode(resp.getInteger("billState")).getDescription());
        resp.put("dataFormat", attrResp.getData().getDataFormat());

        return CommonResponse.success("查询成功！", resp);
    }

}
