package com.ejianc.business.contractbase.pool.contractpool.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractReportVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 合同池主实体
 *
 * @author generator
 */
@RestController
@RequestMapping("contractReport")
public class ContractReportController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractPoolService service;

    @Autowired
    private ISettlePoolService settlePoolService;

    @Autowired
    private IPaymentApplyApi  paymentApplyApi;

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<ContractReportVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("parentOrgName");
        param.getFuzzyFields().add("purchaseName");
        //组织本下id
        List<Long> orgIdList = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        if(!param.getParams().containsKey("sourceType")){
            param.getParams().put("sourceType",new Parameter(QueryParam.IN,Arrays.asList(new String[]{ContractTypeEnum.周转材合同.getTypeCode(),ContractTypeEnum.专业分包合同.getTypeCode(),
                    ContractTypeEnum.劳务分包合同.getTypeCode(),ContractTypeEnum.物资采购合同.getTypeCode(),ContractTypeEnum.混凝土合同.getTypeCode(),ContractTypeEnum.支出合同.getTypeCode(),
                    ContractTypeEnum.其他支出.getTypeCode(),ContractTypeEnum.设备租赁.getTypeCode(),ContractTypeEnum.设备采购.getTypeCode(),ContractTypeEnum.临时设备.getTypeCode(),
                    ContractTypeEnum.安拆合同.getTypeCode(),ContractTypeEnum.辅料中心周转材租赁合同.getTypeCode(),ContractTypeEnum.辅料中心周转材采购合同.getTypeCode()})));
        }
        param.getOrderMap().put("createTime", QueryParam.DESC);
        IPage<ContractPoolEntity> page = service.queryPage(param, false);
        IPage<ContractReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractReportVO.class));
        for (ContractReportVO vo : pageData.getRecords()) {
            if (vo == null) {
                continue;
            }
            // 合同属性：1-收入，0支出
            Integer contractProperty = vo.getContractProperty();
            if (contractProperty != null) {
                if (1 == contractProperty) {
                    vo.setContractPropertyName("收入");
                } else {
                    vo.setContractPropertyName("支出");
                }
            }
            // 合同履约状态
            String performanceStatus = vo.getPerformanceStatus();
            if (StringUtils.isNotBlank(performanceStatus)) {
                ContractPerformanceStateEnum performanceStateEnum = ContractPerformanceStateEnum.getByStateCode(performanceStatus);
                vo.setPerformanceStatusName(performanceStateEnum != null ? performanceStateEnum.getStateName() : "");
            }

            Long orgId = vo.getParentOrgId();
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))){
                orgId = vo.getOrgId();
            }
            if(!orgIdList.contains(orgId)){
                vo.setContractTaxMnyStr("******");
                vo.setTotalPaymentApplyTaxMnyStr("******");
                vo.setTotalSettleTaxMnyStr("******");
                vo.setClickable(false);
            }else{
                // 根据供应商、合同id 查询合同下结算金额
                /*QueryWrapper<SettlePoolEntity> settleWrapper = new QueryWrapper<>();
                settleWrapper.eq("partyb_id",vo.getPartybId());
                settleWrapper.eq("contract_id",vo.getContractId());
                settleWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                List<SettlePoolEntity> settleList = settlePoolService.list(settleWrapper);
                BigDecimal totalSettleTaxMny = settleList.stream().filter(s-> s.getCurTaxMny()!=null ).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO,BigDecimal::add);*/

                QueryWrapper<SettlePoolEntity> wrapper = new QueryWrapper();
                wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
                wrapper.eq("partyb_id",vo.getPartybId());
                wrapper.eq("contract_id",vo.getContractId());
                wrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                wrapper.select("SUM( IF( source_type = 'labor_final' OR source_type = 'pro_final', total_process_tax_difference, cur_tax_mny ) ) cur_tax_mny");
                wrapper.notIn("source_type", Arrays.asList("labor_node", "pro_node"));
                List<SettlePoolEntity> settleList = settlePoolService.list(wrapper);
                BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
                if(settleList.get(0) != null){
                    totalSettleTaxMny = settleList.stream().map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO,BigDecimal::add);
                }

                //获取乙方（供应商）
                Object partybId = param.getParams().get("partybId").getValue();
                long supplierId = Long.valueOf(String.valueOf(partybId)).longValue();
                CommonResponse<JSONObject> response = paymentApplyApi.querySumApplyMny(supplierId, vo.getContractId());
                if(response.isSuccess()){
                    Object sumApplyMny = response.getData().get("sumApplyMny");
                    vo.setTotalPaymentApplyTaxMnyStr(String.valueOf(sumApplyMny));
                }else{
                    vo.setTotalPaymentApplyTaxMnyStr("0");
                }

                vo.setContractTaxMnyStr(vo.getContractTaxMny()!=null && vo.getContractTaxMny() != BigDecimal.ZERO ? String.valueOf(vo.getContractTaxMny().setScale(2, BigDecimal.ROUND_HALF_UP)) : "0");
                vo.setTotalSettleTaxMnyStr(totalSettleTaxMny != null && totalSettleTaxMny != BigDecimal.ZERO ? String.valueOf(totalSettleTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP)) : "0");
                vo.setClickable(true);
            }
        }

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        // 模糊查询字段配置
//        param.setFuzzyFields(Arrays.asList("contractCode","contractName","projectName"));
        param.getFuzzyFields().add("parentOrgName");
        param.getFuzzyFields().add("purchaseName");
        //组织本下id
        List<Long> orgIdList = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        if(!param.getParams().containsKey("sourceType")){
            param.getParams().put("sourceType",new Parameter(QueryParam.IN,Arrays.asList(new String[]{ContractTypeEnum.周转材合同.getTypeCode(),ContractTypeEnum.专业分包合同.getTypeCode(),
                    ContractTypeEnum.劳务分包合同.getTypeCode(),ContractTypeEnum.物资采购合同.getTypeCode(),ContractTypeEnum.混凝土合同.getTypeCode(),ContractTypeEnum.支出合同.getTypeCode(),
                    ContractTypeEnum.其他支出.getTypeCode(),ContractTypeEnum.设备租赁.getTypeCode(),ContractTypeEnum.设备采购.getTypeCode(),ContractTypeEnum.临时设备.getTypeCode(),
                    ContractTypeEnum.安拆合同.getTypeCode(),ContractTypeEnum.辅料中心周转材租赁合同.getTypeCode(),ContractTypeEnum.辅料中心周转材采购合同.getTypeCode()})));
        }
        List<ContractPoolEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ContractReportVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, ContractReportVO.class);
            for (ContractReportVO vo : voList) {
                if (vo == null) {
                    continue;
                }
                // 合同属性：1-收入，0支出
                Integer contractProperty = vo.getContractProperty();
                if (contractProperty != null) {
                    if (1 == contractProperty) {
                        vo.setContractPropertyName("收入");
                    } else {
                        vo.setContractPropertyName("支出");
                    }
                }
                // 合同履约状态
                String performanceStatus = vo.getPerformanceStatus();
                if (StringUtils.isNotBlank(performanceStatus)) {
                    ContractPerformanceStateEnum performanceStateEnum = ContractPerformanceStateEnum.getByStateCode(performanceStatus);
                    vo.setPerformanceStatusName(performanceStateEnum != null ? performanceStateEnum.getStateName() : "");
                }

                Long orgId = vo.getParentOrgId();
                if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))){
                    orgId = vo.getOrgId();
                }
                if(!orgIdList.contains(orgId)){
                    vo.setContractTaxMnyStr("******");
                    vo.setTotalPaymentApplyTaxMnyStr("******");
                    vo.setTotalSettleTaxMnyStr("******");
                }else{
                    // 根据供应商、合同id 查询合同下结算金额
                    /*QueryWrapper<SettlePoolEntity> settleWrapper = new QueryWrapper<>();
                    settleWrapper.eq("partyb_id",vo.getPartybId());
                    settleWrapper.eq("contract_id",vo.getContractId());
                    settleWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                    List<SettlePoolEntity> settleList = settlePoolService.list(settleWrapper);
                    BigDecimal totalSettleTaxMny = settleList.stream().filter(s-> s.getCurTaxMny()!=null ).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO,BigDecimal::add);*/
                    QueryWrapper<SettlePoolEntity> wrapper = new QueryWrapper();
                    wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
                    wrapper.eq("partyb_id",vo.getPartybId());
                    wrapper.eq("contract_id",vo.getContractId());
                    wrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                    wrapper.select("SUM( IF( source_type = 'labor_final' OR source_type = 'pro_final', total_process_tax_difference, cur_tax_mny ) ) cur_tax_mny");
                    wrapper.notIn("source_type", Arrays.asList("labor_node", "pro_node"));
                    List<SettlePoolEntity> settleList = settlePoolService.list(wrapper);
                    BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
                    if(settleList.get(0) != null){
                        totalSettleTaxMny = settleList.stream().map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO,BigDecimal::add);
                    }

                    //获取乙方（供应商）
                    Object partybId = param.getParams().get("partybId").getValue();
                    long supplierId = Long.valueOf(String.valueOf(partybId)).longValue();
                    CommonResponse<JSONObject> res = paymentApplyApi.querySumApplyMny(supplierId, vo.getContractId());
                    if(res.isSuccess()){
                        Object sumApplyMny = res.getData().get("sumApplyMny");
                        vo.setTotalPaymentApplyTaxMnyStr(String.valueOf(sumApplyMny));
                    }else{
                        vo.setTotalPaymentApplyTaxMnyStr("0");
                    }

                    vo.setContractTaxMnyStr(vo.getContractTaxMny()!=null && vo.getContractTaxMny() != BigDecimal.ZERO ? String.valueOf(vo.getContractTaxMny().setScale(2, BigDecimal.ROUND_HALF_UP)) : "0");
                    vo.setTotalSettleTaxMnyStr(totalSettleTaxMny != null && totalSettleTaxMny != BigDecimal.ZERO ? String.valueOf(totalSettleTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP)) : "0");
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("ContractReport-export.xlsx", beans, response);
    }

}
