package com.ejianc.business.contractbase.pool.contractpool.service;

import com.ejianc.business.contractbase.pool.contractpool.vo.ContractSubPaymentNodeVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractSubPaymentNodeEntity;

import java.util.List;

/**
 * 合同付款节点子实体
 *
 * @author generator
 */
public interface IContractSubPaymentNodeService extends IBaseService<ContractSubPaymentNodeEntity> {

	/**
	 * 根据主表Id查询子表列表
	 *
	 * @param pid
	 *
	 * @return
	 */
	List<ContractSubPaymentNodeEntity> listByPid(Long pid);

	/**
	 * 根据合同id查询合同池付款阶段详情
	 *
	 * @param contractId 合同id
	 *
	 * @return 合同池付款阶段详情
	 */
	List<ContractSubPaymentNodeVO> queryDetailByContractId(Long contractId);
}
