package com.ejianc.business.contractbase.pool.contractpool.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractSubPaymentNodeVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.contractbase.pool.contractpool.mapper.ContractSubPaymentNodeMapper;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractSubPaymentNodeEntity;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractSubPaymentNodeService;

import java.util.List;

/**
 * 合同付款节点子实体
 *
 * @author generator
 */
@Service("contractSubPaymentNodeService")
public class ContractSubPaymentNodeServiceImpl extends BaseServiceImpl<ContractSubPaymentNodeMapper, ContractSubPaymentNodeEntity> implements IContractSubPaymentNodeService {

	@Override
	public List<ContractSubPaymentNodeEntity> listByPid(Long pid) {
		QueryWrapper<ContractSubPaymentNodeEntity> query = new QueryWrapper();
		query.eq("pid", pid);
		return super.list(query);
	}

	/**
	 * 根据合同id查询合同池付款阶段详情
	 *
	 * @param contractId 合同id
	 *
	 * @return 合同池付款阶段详情
	 */
	@Override
	public List<ContractSubPaymentNodeVO> queryDetailByContractId(Long contractId) {
		LambdaQueryWrapper<ContractSubPaymentNodeEntity> queryWrapper = Wrappers.lambdaQuery();
		queryWrapper.eq(ContractSubPaymentNodeEntity::getPid, contractId);
		List<ContractSubPaymentNodeEntity> restult = super.list(queryWrapper);
		return BeanMapper.mapList(restult, ContractSubPaymentNodeVO.class);
	}
}
