package com.ejianc.business.contractbase.pool.settlepool.bean;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 结算池穿透URL中间表实体
 * <p>
 * 结算单类型/合同类型每个类型都对应一个URL，对于穿透类型字段，可以有一下值（key）：
 * <p>
 * 结算单类型（key-name）：
 * product_value-产值报量,
 * product_value_first-对甲报量,
 * settle_verify-结算报审,
 * project_decide-工程定案,
 * material_week_rent_out-周转材租出结算,
 * material_week_rent_in-周转材租入结算,
 * equip_rent_out-设备租出结算,
 * equip_rent_in-设备租入结算,
 * labor_month-劳务分包月度结算,
 * labor_node-劳务分包节点结算,
 * labor_final-劳务分包最终结算,
 * pro_month-专业分包月度结算,
 * pro_node-专业分包节点结算,
 * pro_final-专业分包最终结算,
 * material_buy_in-物资采购结算,
 * equip_buy_in-设备采购结算,
 * beton_buy_in-混凝土采购结算,
 * temp_equip-临时设备结算,
 * big_equip_install_uninstall-大型设备安拆结算,
 * law_cost-诉讼费结算,
 * other_in-其他收入结算,
 * other_out-其他支出结算。
 * <p>
 * 合同类型（key-name）：
 * contraction-施工合同，
 * prosub-专业分包合同，
 * laborsub-劳务分包合同，
 * materialPurchase-物资采购合同，
 * concrete-混凝土合同，
 * otherIn-其他收入合同，
 * otherOut-其他支出合同，
 * equipmentPurchase-设备采购合同，
 * equipmentRent-设备租赁合同，
 * promat-周转材合同。
 *
 * @author generator
 */
@TableName("ejc_conbase_bill_url_dict")
public class BillUrlDictEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "create_user_name")
    private String createUserName; // 创建者名称
    @TableField(value = "update_user_name")
    private String updateUserName; // 修改者名称
    @TableField(value = "source_type")
    private String sourceType; // 穿透类型
    @TableField(value = "source_detail_url")
    private String sourceDetailUrl; // 结算单来源
    @TableField(value = "ext1")
    private String ext1; // 扩展字段
    @TableField(value = "ext2")
    private String ext2; // 扩展字段
    @TableField(value = "ext3")
    private String ext3; // 扩展字段
    @TableField(value = "ext4")
    private String ext4; // 扩展字段
    @TableField(value = "ext5")
    private String ext5; // 扩展字段
    @TableField(value = "ext6")
    private String ext6; // 扩展字段
    @TableField(value = "ext7")
    private String ext7; // 扩展字段
    @TableField(value = "ext8")
    private String ext8; // 扩展字段


    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceDetailUrl() {
        return sourceDetailUrl;
    }

    public void setSourceDetailUrl(String sourceDetailUrl) {
        this.sourceDetailUrl = sourceDetailUrl;
    }

    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

}
