package com.ejianc.business.contractbase.pool.settlepool.service.impl;

import com.ejianc.business.contractbase.pool.settlepool.bean.BillUrlDictEntity;
import com.ejianc.business.contractbase.pool.settlepool.mapper.BillUrlDictMapper;
import com.ejianc.business.contractbase.pool.settlepool.service.IBillUrlDictService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2022/4/20 14:51
 */
@Service("billUrlDictService")
public class BillUrlDictServiceImpl extends BaseServiceImpl<BillUrlDictMapper, BillUrlDictEntity> implements IBillUrlDictService {

    @Autowired
    private BillUrlDictMapper billUrlDictMapper;

    @Override
    public Map<String, String> getDictMapBySourceTypes(List<String> sourceTypes) {
        Map<String, String> resp = new HashMap<>();
        List<BillUrlDictEntity> list = billUrlDictMapper.queryBillUrlList(sourceTypes);

        if(CollectionUtils.isNotEmpty(list)) {
            list.forEach(item -> {
                resp.put(item.getSourceType(), item.getSourceDetailUrl());
            });
        }

        return resp;
    }
}
