package com.ejianc.business.contractbase.pool.util;

import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2022/3/29 10:06
 */
public class BeanUtil {

    /**
     * 获取到对象为空的属性列表
     *
     * @param source 源对象
     * @param condition 判空条件
     * @return
     */
    public static String[] getPropertyNames(Object source, String condition) {
        final BeanWrapper src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        String[] rs = Arrays.stream(pds).filter(item -> {
            Object objVal = src.getPropertyValue(item.getName());
            if(UpdateLevelEnum.更新非NULL字段.getLevelCode().equals(condition)) {
                return null == objVal;
            } else {
                if(null == objVal) {
                    return true;
                }
                if(objVal instanceof List) {
                    return ((List) objVal).isEmpty();
                } else if(objVal instanceof Arrays) {
                    return ((Object[])objVal).length == 0;
                } else if(objVal instanceof Map) {
                    return ((Map) objVal).isEmpty();
                } else if(objVal instanceof String) {
                    return StringUtils.isBlank(objVal.toString());
                }
                return false;
            }
        }).map(PropertyDescriptor::getName).toArray(String[]::new);

        return rs.length > 0 ? rs : null;
    }

}
