package com.ejianc.business.contractbase.service;

import com.ejianc.business.contractbase.entity.CategoryRelationEntity;
import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * @author:刘家乐
 * @version:
 * @date:2021/11/9
 * @document:
 */
public interface ICategoryRelationService extends IBaseService<CategoryRelationEntity> {

    /**
     *  刘家乐
     * @param entity 当前条款
     * @param ids 分类id字符串
     * @return 返回当前条款选择的 顶级分类数量
     */
    int saveCategoryRelation(ClauseSettingEntity entity, String ids);


    /**
     * 添加分类一对多条款的关系数据
     * @param templateCategoryEntity
     * @param clauseList
     */
    void addRelationByCategory(TemplateCategoryEntity templateCategoryEntity, List<ClauseSettingEntity> clauseList);

    /**
     * 通过分类id物理删除分类条款关系
     * @param categoryIds
     */
    void deleteRelationByCategory(List<Long> categoryIds);

    /**
     * 通过条款id物理删除分类条款关系
     * @param clauseIds
     */
    void deleteRelationByClause(List<Long> clauseIds);
}
