package com.ejianc.business.contractbase.service;

import com.ejianc.business.contractbase.entity.TemplDetailExportSettingEntity;
import com.ejianc.business.contractbase.vo.tempDetail.TemplDetailExportSettingVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2022/11/8 10:54
 */
public interface ITemplDetailExportSettingService extends IBaseService<TemplDetailExportSettingEntity> {
    /**
     * 合同分类导出模板保存
     *
     * @param vos
     */
    void saveOrUpdateVos(List<TemplDetailExportSettingVO> vos);

    /**
     * 根据合同分类Id查询所有可用的导出模板列表
     *
     * @param categoryId
     * @return
     */
    List<TemplDetailExportSettingEntity> findExportDetailByCategoryId(Long categoryId, Long parentCategoryId);

    /**
     * 查询匹配模板的子表导出模板依据类型
     *
     * @param templIdList
     * @return
     */
    Map<String, String> getTemplExportMode(List<Long> templIdList);

    /**
     * 物理删除匹配的清单设置
     *
     * @param templateId
     * @return
     */
    void delByTemplateId(Long templateId);
}
