package com.ejianc.business.contractbase.service.impl;

import com.ejianc.business.contractbase.entity.CategoryRelationEntity;
import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.mapper.CategoryRelationMapper;
import com.ejianc.business.contractbase.mapper.ClauseSettingMapper;
import com.ejianc.business.contractbase.service.ICategoryRelationService;
import com.ejianc.business.contractbase.service.IClauseSettingService;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author:刘家乐
 * @version: 1
 * @date:2021/11/9
 * @document:
 */
@Service
public class ClauseSettingServiceImpl
        extends BaseServiceImpl<ClauseSettingMapper, ClauseSettingEntity>
        implements IClauseSettingService {

    @Autowired
    private ICategoryRelationService relationService;

    @Autowired
    private CategoryRelationMapper categoryRelationMapper;

    @Override
    public boolean checkCategory(Long categoryId){
        boolean check = false;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("category_id",new Parameter("eq",categoryId));
        List<CategoryRelationEntity> categoryRelationEntities = relationService.queryList(queryParam);
        if (!categoryRelationEntities.isEmpty()){
            for (CategoryRelationEntity c:categoryRelationEntities){
                ClauseSettingEntity clauseSettingEntity = this.selectById(c.getClauseId());
                if (1 == clauseSettingEntity.getEnableStatus()){
                    check = true;
                    break;
                }
            }
        }
        return check;
    }

    @Override
    public void updateClauseByCategory(TemplateCategoryEntity templateCategoryEntity, Boolean insertFlag, String newCategoryName) {
        //找到全分类可用的条款，更新其可用分类名称、id
        QueryParam queryParam = new QueryParam();
        if (insertFlag){
            //新增
            queryParam.getParams().put("enable_type", new Parameter(QueryParam.EQ, 1));
        }else {
            //修改
            queryParam.getParams().put("rangeIds", new Parameter(QueryParam.LIKE, "%" + templateCategoryEntity.getId() + "%"));
        }
        List<ClauseSettingEntity> clauseList = super.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(clauseList)){
            for (ClauseSettingEntity clause : clauseList){
                //如果新分类名称newCategoryName为空，证明分类名称未修改
                if (insertFlag){
                    //如果是新增的分类，直接在条款的可用分类后新增一条数据
                    clause.setRangeIds(clause.getRangeIds() + "," + templateCategoryEntity.getId());
                    clause.setRangeNames(clause.getRangeNames() + "," + templateCategoryEntity.getCategoryName());
                }else {
                    if (null != newCategoryName && StringUtils.isNotBlank(newCategoryName)){
                        //如果是分类修改，则在条款的可用分类名称中替换原来的分类名称
                        String oldRangeNames = "," + clause.getRangeNames() + ",";
                        oldRangeNames = oldRangeNames.replace("," + templateCategoryEntity.getCategoryName() + ",", "," + newCategoryName + ",");
                        oldRangeNames = oldRangeNames.substring(1, oldRangeNames.length() - 1);
                        clause.setRangeNames(oldRangeNames);
                    }
                }
            }
            super.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }

        //更新分类、条款关系表，添加多条数据（分类一对多条款）
        relationService.addRelationByCategory(templateCategoryEntity, clauseList);
    }

    /**
     * 1.删除条款
     * 2.物理删除分类条款关系表 关于该条款的所有信息
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void removeRelationByClause(List<Long> ids) {
        //1.删除条款
        super.removeByIds(ids, true);
        //2.物理删除分类条款关系表 关于该条款的所有信息
        categoryRelationMapper.deleteRelationByClause(ids);
    }

    @Override
    public ClauseSettingVO updateStatus(ClauseSettingVO clauseSettingVO) {
        ClauseSettingEntity clauseSettingEntity = this.selectById(clauseSettingVO.getId());
        if(null != clauseSettingVO.getEnableStatus()) {
            clauseSettingEntity.setEnableStatus(clauseSettingVO.getEnableStatus());
        }
        if(null != clauseSettingVO.getNecessaryStatus()) {
            clauseSettingEntity.setNecessaryStatus(clauseSettingVO.getNecessaryStatus());
        }
        this.saveOrUpdate(clauseSettingEntity,false);
        return  BeanMapper.map(clauseSettingEntity, ClauseSettingVO.class);
    }

}
