/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.pool.contractpool.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractSubPaymentNodeService;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractSubPaymentNodeVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.HeadUserVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupHisPerformanceVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplierInfoVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplyVO;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class ContractPoolApiController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractPoolService contractPoolService;
    @Autowired
    private IContractSubPaymentNodeService nodeService;
    @Autowired
    private ISettlePoolService settleService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String BILL_CODE = "CONTRACT_POOL";

    @PostMapping(value={"/api/contractpool/updatePerformanceStatusByContractId"})
    public CommonResponse<ContractPoolVO> updatePerformanceStatusByContractId(@RequestBody ContractPoolVO contractPoolVO) {
        this.logger.info("\u63a5\u6536\u5408\u540c\u540c\u6b65\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
        ContractPoolVO resp = this.contractPoolService.updatePerformanceStatusByContractId(contractPoolVO);
        return CommonResponse.success((String)"\u66f4\u65b0\u5408\u540c\u6c60\u4e2d\u5408\u540c\u7684\u5c65\u7ea6\u72b6\u6001\u6210\u529f", (Object)resp);
    }

    @PostMapping(value={"/api/contractpool/updatePerformanceStatusById"})
    public CommonResponse<ContractPoolVO> updatePerformanceStatusById(@RequestBody ContractPoolVO contractPoolVO) {
        return this.updatePerformanceStatusByContractId(contractPoolVO);
    }

    @PostMapping(value={"/api/contractpool/saveOrUpdateContract"})
    public CommonResponse<ContractPoolVO> saveOrUpdateContract(@RequestBody ContractPoolVO contract) {
        this.logger.info("\u63a5\u6536\u5408\u540c\u540c\u6b65\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contract));
        ContractPoolVO resp = this.contractPoolService.saveOrUpdateContract(contract);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"/api/contractpool/deleteContract"})
    public CommonResponse<String> deleteContract(@RequestBody ContractPoolVO contract) {
        this.logger.info("\u63a5\u6536\u5408\u540c-{}\u5220\u9664\u8bf7\u6c42", (Object)JSONObject.toJSONString((Object)contract));
        ContractPoolEntity contractEntity = null;
        if (null != contract.getSourceId()) {
            contractEntity = (ContractPoolEntity)((Object)this.contractPoolService.selectById(contract.getSourceId()));
        }
        if (null == contractEntity && null != contract.getId()) {
            contractEntity = (ContractPoolEntity)((Object)this.contractPoolService.selectById(contract.getId()));
        }
        if (null == contractEntity) {
            this.logger.info("\u5408\u540c-\u3010{}\u3011\u5220\u9664\u64cd\u4f5c\u7ed3\u675f\uff0c\u5728\u5408\u540c\u6c60\u4e2d\u65e0\u5339\u914d\u7684\u6570\u636e\uff01", (Object)JSONObject.toJSONString((Object)contract));
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote("EJCBT202204000016", contractEntity.getId());
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.contractPoolService.removeById(contractEntity.getId(), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ResponseBody
    @RequestMapping(value={"/api/contractpool/queryPayment"}, method={RequestMethod.GET})
    public CommonResponse<List<ContractSubPaymentNodeVO>> queryPayment(@RequestParam(value="contractId") String contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)contractId));
        List contractSubPaymentNodeEntities = this.nodeService.queryList(queryParam);
        List contractSubPaymentNodeVOS = BeanMapper.mapList((Iterable)contractSubPaymentNodeEntities, ContractSubPaymentNodeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)contractSubPaymentNodeVOS);
    }

    @ResponseBody
    @RequestMapping(value={"/api/contractpool/queryContractByCode"}, method={RequestMethod.GET})
    public CommonResponse<ContractPoolVO> queryContractByCode(@RequestParam(value="contractCode") String contractCode) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractCode", new Parameter("eq", (Object)contractCode));
        List contractPoolVOList = this.contractPoolService.queryList(queryParam);
        ContractPoolVO contractPoolVO = new ContractPoolVO();
        if (CollectionUtils.isNotEmpty((Collection)contractPoolVOList) && contractPoolVOList.get(0) != null) {
            contractPoolVO = (ContractPoolVO)BeanMapper.map(contractPoolVOList.get(0), ContractPoolVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)contractPoolVO);
    }

    @PostMapping(value={"/api/contractpool/queryList"})
    public CommonResponse<List<ContractPoolVO>> queryList(@RequestBody QueryParam queryParam) {
        List resp = new ArrayList();
        List entityList = this.contractPoolService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            resp = BeanMapper.mapList((Iterable)entityList, ContractPoolVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"/api/contractpool/queryContractMny"})
    public CommonResponse<BigDecimal> queryContractMny(@RequestBody QueryParam queryParam) {
        Parameter project_id;
        Parameter projectId = (Parameter)queryParam.getParams().get("projectId");
        if (null != projectId && "in".equals(projectId.getType().toLowerCase()) && CollectionUtils.isEmpty((Collection)JSONObject.parseArray((String)JSONObject.toJSONString((Object)projectId.getValue())))) {
            queryParam.getParams().remove("projectId");
        }
        if (null != (project_id = (Parameter)queryParam.getParams().get("project_id")) && "in".equals(project_id.getType().toLowerCase()) && CollectionUtils.isEmpty((Collection)JSONObject.parseArray((String)JSONObject.toJSONString((Object)project_id.getValue())))) {
            queryParam.getParams().remove("project_id");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"IFNULL(SUM(contract_tax_mny),0) as contractTaxMny"});
        ContractPoolEntity entity = (ContractPoolEntity)((Object)this.contractPoolService.getOne((Wrapper)wrapper));
        QueryWrapper objectQueryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        objectQueryWrapper.select(new String[]{"IFNULL(SUM(total_reply_tax_mny),0) as totalTeplyTaxMny"});
        ContractPoolEntity one = (ContractPoolEntity)((Object)this.contractPoolService.getOne((Wrapper)objectQueryWrapper));
        BigDecimal contractTaxMny = ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMny(), (BigDecimal)one.getTotalTeplyTaxMny());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)contractTaxMny);
    }

    @PostMapping(value={"/api/contractpool/querySumContractMny"})
    public CommonResponse<BigDecimal> querySumContractMny(@RequestBody QueryParam queryParam) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"IFNULL(SUM(contract_tax_mny),0) as contractTaxMny"});
        ContractPoolEntity entity = (ContractPoolEntity)((Object)this.contractPoolService.getOne((Wrapper)wrapper));
        BigDecimal contractTaxMny = entity.getContractTaxMny();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)contractTaxMny);
    }

    @PostMapping(value={"/api/contractpool/getContractList"})
    public CommonResponse<JSONArray> getContractList(@RequestBody SupplyVO vo) {
        this.logger.info("\u63a5\u6536\u5230\u8bf7\u6c42\u53c2\u6570:" + JSONObject.toJSONString((Object)vo));
        List<ContractDTO> contractList = this.contractPoolService.getContractList(vo);
        this.logger.info("\u67e5\u8be2\u7ed3\u679c:" + JSONObject.toJSONString(contractList));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)JSONObject.parseArray((String)JSONObject.toJSONString(contractList)));
    }

    @PostMapping(value={"/api/contractpool/getSupplierSignMny"})
    public CommonResponse<List<ContractPoolVO>> getSupplierSignMny(@RequestBody ContractPoolVO vo) {
        this.logger.info("\u63a5\u6536\u5230\u8bf7\u6c42\u53c2\u6570:111");
        List<ContractPoolVO> list = this.contractPoolService.getSupplierSignMny();
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", list);
    }

    @PostMapping(value={"/api/contractpool/getContractListByHeadUser"})
    public CommonResponse<JSONArray> getContractListByHeadUser(@RequestBody HeadUserVO vo) {
        this.logger.info("\u63a5\u6536\u5230\u8bf7\u6c42\u53c2\u6570:" + JSONObject.toJSONString((Object)vo));
        List<ContractDTO> contractList = this.contractPoolService.getContractListByHeadUser(vo);
        this.logger.info("\u67e5\u8be2\u7ed3\u679c:" + JSONObject.toJSONString(contractList));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)JSONObject.parseArray((String)JSONObject.toJSONString(contractList)));
    }

    @GetMapping(value={"/api/contractpool/supHisPerformanceList"})
    public CommonResponse<List<SupHisPerformanceVO>> supHisPerformanceList(@RequestParam Long supplierId) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"if(source_type = 'laborSub', supplier_project_manager_name, '') as headUserName, project_name as engineeringName, project_address as engineeringAddress,  partya_name as cooperationOrg, source_type_name as cooperationContent, contract_tax_mny as contractMny, contract_name as contractName, category_name as contractCategoryName,  supplier_project_manager_name as supplierManagerName, supplier_project_manager_link as supplierManagerLink, source_type as contractCategoryProperty, sign_date as startDay, finish_settle_date as endDay, employee_name as contacts, employee_phone as contactsPhone, partyb_id as supplierId"});
        query.eq((Object)"partyb_id", (Object)supplierId);
        List mapList = this.contractPoolService.listMaps((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)mapList)) {
            resp = BeanMapper.mapList((Iterable)mapList, SupHisPerformanceVO.class);
        }
        return CommonResponse.success(resp);
    }

    @ResponseBody
    @RequestMapping(value={"/api/contractpool/queryById"}, method={RequestMethod.GET})
    public CommonResponse<ContractPoolVO> queryById(@RequestParam(value="contractId") Long contractId) {
        ContractPoolEntity contractPoolEntity = (ContractPoolEntity)((Object)this.contractPoolService.selectById(contractId));
        if (contractPoolEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01\u6839\u636eid\u672a\u67e5\u8be2\u5230\u5408\u540c");
        }
        ContractPoolVO vo = (ContractPoolVO)BeanMapper.map((Object)((Object)contractPoolEntity), ContractPoolVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ResponseBody
    @RequestMapping(value={"/api/contractpool/queryContractHonourMny"}, method={RequestMethod.POST})
    public CommonResponse<BigDecimal> queryContractHonourMny(@RequestBody ContractPoolVO vo) {
        BigDecimal bigDecimal = this.contractPoolService.queryContractHonourMny(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)bigDecimal);
    }

    @GetMapping(value={"/api/contractpool/queryContractionSubtractProTaxMny"})
    public CommonResponse<BigDecimal> queryContractionSubtractProTaxMny(@RequestParam Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.contractPoolService.queryContractionSubtractProTaxMny(projectId));
    }

    @ResponseBody
    @RequestMapping(value={"/api/contractpool/queryContractSettleTaxMny"}, method={RequestMethod.POST})
    public CommonResponse<List<SupplierInfoVO>> queryContractSettleTaxMny(@RequestBody SupplierInfoVO vo) {
        ArrayList<SupplierInfoVO> vos = new ArrayList<SupplierInfoVO>();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"IFNULL(SUM(contract_tax_mny),0) as contractTaxMny,partyb_id"});
        wrapper.in((Object)"partyb_id", (Collection)vo.getSupplierIds());
        wrapper.in((Object)"org_id", (Collection)vo.getOrgIds());
        wrapper.groupBy((Object[])new String[]{"partyb_id"});
        List list = this.contractPoolService.list((Wrapper)wrapper);
        QueryWrapper settleWrapper = new QueryWrapper();
        wrapper.select(new String[]{"IFNULL(SUM(cur_tax_mny),0) as curTaxMny,partyb_id"});
        settleWrapper.in((Object)"partyb_id", (Collection)vo.getSupplierIds());
        settleWrapper.in((Object)"org_id", (Collection)vo.getOrgIds());
        settleWrapper.groupBy((Object[])new String[]{"partyb_id"});
        List settleList = this.settleService.list((Wrapper)settleWrapper);
        Map<Long, SettlePoolEntity> settlePoolMap = settleList.stream().collect(Collectors.toMap(k -> k.getPartybId(), k -> k));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ContractPoolEntity entity : list) {
                SupplierInfoVO supplierInfoVO = new SupplierInfoVO();
                supplierInfoVO.setContractTaxMny(entity.getContractTaxMny());
                if (settlePoolMap.containsKey(entity.getPartybId())) {
                    supplierInfoVO.setSettleTaxMny(settlePoolMap.get(entity.getPartybId()).getCurTaxMny());
                }
                supplierInfoVO.setSupplierId(entity.getPartybId());
                vos.add(supplierInfoVO);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", vos);
    }

    @GetMapping(value={"/api/contractpool/queryThisYearContractMny"})
    public CommonResponse<BigDecimal> queryThisYearContractMny(@RequestParam(value="sourceType", required=false) String sourceType, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"IFNULL(SUM(total_reply_tax_mny),0) as totalTeplyTaxMny"});
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)dateIn), (Object)"DATE_FORMAT(sign_date,\"%Y\")", (Object)dateIn);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)sourceType), (Object)"source_type", (Object)sourceType);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"IFNULL(SUM(contract_tax_mny),0) as contractTaxMny"});
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)dateIn), (Object)"DATE_FORMAT(sign_date,\"%Y\")", (Object)dateIn);
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)sourceType), (Object)"source_type", (Object)sourceType);
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(_orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            wrapper.in((Object)"parent_org_id", commonOrgIds);
            queryWrapper.in((Object)"parent_org_id", commonOrgIds);
        } else if (departmentIds.size() != 0) {
            wrapper.in((Object)"org_id", departmentIds);
            queryWrapper.in((Object)"org_id", departmentIds);
        }
        ContractPoolEntity entity = (ContractPoolEntity)((Object)this.contractPoolService.getOne((Wrapper)wrapper));
        ContractPoolEntity one = (ContractPoolEntity)((Object)this.contractPoolService.getOne((Wrapper)queryWrapper));
        BigDecimal contractTaxMny = ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMny(), (BigDecimal)one.getTotalTeplyTaxMny());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)contractTaxMny);
    }

    @GetMapping(value={"/api/contractpool/updateActualPayRecMny"})
    public CommonResponse<String> updateActualPayRecMny(@RequestParam(value="contractId") Long contractId, @RequestParam(value="taxMny") BigDecimal taxMny, @RequestParam(value="mny") BigDecimal mny, @RequestParam(value="flag") boolean flag) {
        LambdaUpdateWrapper query = new LambdaUpdateWrapper();
        query.eq(ContractPoolEntity::getContractId, (Object)contractId);
        if (flag) {
            query.setSql("total_actual_pay_rec_tax_mny = IFNULL(total_actual_pay_rec_tax_mny,0) + IFNULL(" + taxMny + ",0),total_actual_pay_rec_mny = IFNULL(total_actual_pay_rec_mny,0) + IFNULL(" + mny + ",0)");
        } else {
            query.setSql("total_actual_pay_rec_tax_mny = IFNULL(total_actual_pay_rec_tax_mny,0) - IFNULL(" + taxMny + ",0),total_actual_pay_rec_mny = IFNULL(total_actual_pay_rec_mny,0) - IFNULL(" + mny + ",0)");
        }
        this.contractPoolService.update((Wrapper)query);
        return CommonResponse.success((String)"\u56de\u5199\u6210\u529f");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

