/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.disclose.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.disclose.bean.ContractArchiveDetailEntity;
import com.ejianc.business.contractbase.disclose.bean.ContractArchiveDetailFileEntity;
import com.ejianc.business.contractbase.disclose.bean.ContractArchiveEntity;
import com.ejianc.business.contractbase.disclose.service.IContractArchiveDetailFileService;
import com.ejianc.business.contractbase.disclose.service.IContractArchiveService;
import com.ejianc.business.contractbase.disclose.vo.ContractArchiveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"contractArchive"})
public class ContractArchiveController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "CONTRACT_ARCHIVE";
    @Autowired
    private IContractArchiveService service;
    @Autowired
    private IContractArchiveDetailFileService detailFileService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractArchiveVO> saveOrUpdate(@RequestBody ContractArchiveVO saveOrUpdateVO) {
        ContractArchiveEntity entity;
        if (null != saveOrUpdateVO.getBillCode()) {
            List billCodeEntityList;
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"bill_code", (Object)saveOrUpdateVO.getBillCode());
            if (null != saveOrUpdateVO.getId()) {
                query.ne((Object)"id", (Object)saveOrUpdateVO.getId());
            }
            if (CollectionUtils.isNotEmpty((Collection)(billCodeEntityList = this.service.list((Wrapper)query)))) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7ec4\u5377\u53f7\u91cd\u590d\uff01");
            }
        }
        if (null == (entity = (ContractArchiveEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractArchiveEntity.class))).getBillCode() || StringUtils.isBlank((CharSequence)entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<Object> oldFileIdList = new ArrayList();
        if (null == entity.getId()) {
            entity.setId(IdWorker.getId());
        } else {
            List detailFileEntityList = this.detailFileService.list((Wrapper)new QueryWrapper().eq((Object)"contract_archive_id", (Object)entity.getId()));
            if (CollectionUtils.isNotEmpty((Collection)detailFileEntityList)) {
                oldFileIdList = detailFileEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList()) && entity.getDetailList().size() > 0) {
            ArrayList delList = new ArrayList();
            ArrayList<ContractArchiveDetailFileEntity> addList = new ArrayList<ContractArchiveDetailFileEntity>();
            for (ContractArchiveDetailEntity detailEntity : entity.getDetailList()) {
                if (null == detailEntity.getId()) {
                    detailEntity.setId(IdWorker.getId());
                }
                if (!CollectionUtils.isNotEmpty(detailEntity.getFileList()) || detailEntity.getFileList().size() <= 0) continue;
                for (ContractArchiveDetailFileEntity fileEntity : detailEntity.getFileList()) {
                    if ("add".equals(fileEntity.getRowState())) {
                        fileEntity.setContractArchiveId(entity.getId());
                        fileEntity.setContractArchiveDetailId(detailEntity.getId());
                    }
                    oldFileIdList.remove(fileEntity.getId());
                    addList.add(fileEntity);
                }
            }
            if (oldFileIdList.size() > 0) {
                this.detailFileService.removeByIds(oldFileIdList);
            }
            if (addList.size() > 0) {
                this.detailFileService.saveOrUpdateBatch(addList, addList.size(), false);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ContractArchiveVO vo = (ContractArchiveVO)BeanMapper.map((Object)((Object)entity), ContractArchiveVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractArchiveVO> queryDetail(Long id) {
        ContractArchiveEntity entity = (ContractArchiveEntity)((Object)this.service.selectById(id));
        if (CollectionUtils.isNotEmpty(entity.getDetailList()) && entity.getDetailList().size() > 0) {
            List detailFileList = this.detailFileService.list((Wrapper)new QueryWrapper().eq((Object)"contract_archive_id", (Object)entity.getId()));
            Map<Object, Object> detailFileMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)detailFileList) && detailFileList.size() > 0) {
                detailFileMap = detailFileList.stream().collect(Collectors.groupingBy(ContractArchiveDetailFileEntity::getContractArchiveDetailId));
            }
            for (ContractArchiveDetailEntity contractArchiveDetailEntity : entity.getDetailList()) {
                if (!detailFileMap.containsKey(contractArchiveDetailEntity.getId())) continue;
                contractArchiveDetailEntity.setFileList((List)detailFileMap.get(contractArchiveDetailEntity.getId()));
            }
        }
        ContractArchiveVO vo = (ContractArchiveVO)BeanMapper.map((Object)((Object)entity), ContractArchiveVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractArchiveVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractArchiveVO vo : vos) {
                this.detailFileService.remove((Wrapper)new QueryWrapper().eq((Object)"contract_archive_id", (Object)vo.getId()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractArchiveVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("discloseName");
        fuzzyFields.add("transferFileName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractArchiveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("discloseName");
        fuzzyFields.add("transferFileName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resList = BeanMapper.mapList((Iterable)list, ContractArchiveVO.class);
            resList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", resList);
        ExcelExport.getInstance().export("ContractArchive-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refContractArchiveData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractArchiveVO>> refContractArchiveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractArchiveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

