/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.pool.settlepool.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.BillUrlDictEntity;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/settlePool"})
public class SettlePoolController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    private static final String BILL_CODE = "SETTLE_POOL_TEMP";
    private static final String BILL_CODE_NO_CONTRACT = "SETTLE_POOL_NO_CONTRACT_TEMP";
    @Autowired
    private ISettlePoolService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;
    private final String FINISH_SETTLE_CALC_TYPE = "P-2hiWQQ0131";
    private final String CALC_WITH_PROCESS_SETTLE = "1";
    private final String CALC_WITH_NODE_SETTLE = "2";
    @Autowired
    private IParamConfigApi paramConfigApi;
    private String PROJECT_SETTLE_RANGE_PARAM = "P-zF77230174";

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<SettlePoolVO> saveOrUpdate(@RequestBody SettlePoolVO saveOrUpdateVO) {
        SettlePoolEntity entity = (SettlePoolEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlePoolEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCodeRes;
            BillCodeParam billCodeParam = new BillCodeParam();
            if (entity.getContractFlag() != null) {
                billCodeParam = entity.getContractFlag() == 0 ? BillCodeParam.build((String)BILL_CODE_NO_CONTRACT, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO) : BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            }
            if ((billCodeRes = this.billCodeApi.generateBillCode(billCodeParam)).isSuccess()) {
                entity.setBillCode((String)billCodeRes.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SettlePoolVO vo = (SettlePoolVO)BeanMapper.map((Object)((Object)entity), SettlePoolVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlePoolVO> vos) {
        QueryWrapper query = new QueryWrapper();
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        query.in((Object)"id", ids);
        List settleList = this.service.list((Wrapper)query);
        for (SettlePoolEntity settle : settleList) {
            CommonResponse res = this.billTypeApi.checkQuote(null != settle.getContractId() ? "EJCBT202205000007" : "EJCBT202205000006", settle.getId());
            this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5\uff1a{}", (Object)JSONObject.toJSONString((Object)res));
            if (res.isSuccess()) continue;
            return CommonResponse.error((String)("\u7ed3\u7b97\u5355[" + settle.getBillCode() + "]\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        CommonResponse response = this.paramConfigApi.getByCode("P-2hiWQQ0131");
        String defaultCalcType = "1";
        if (!response.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5e73\u53f0\u7cfb\u7edf\u53c2\u6570\uff0c\u5206\u5305\u5b8c\u5de5\u5dee\u989d\u8ba1\u7b97\u65b9\u5f0f-\u3010{}\u3011\u5931\u8d25, {}", (Object)"P-2hiWQQ0131", (Object)JSONObject.toJSONString((Object)response));
        } else {
            defaultCalcType = ((ParamRegisterSetVO)response.getData()).getValueData();
        }
        resp.put("finishSettleCalcType", (Object)defaultCalcType);
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "partyaName", "partybName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = null;
        String orgType = null;
        if (null != param.getParams().get("orgId") && null != param.getParams().get("orgType")) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString();
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        } else {
            orgType = InvocationInfoProxy.getOrgType();
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(orgType))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        String projectRange = null != param.getParams().get("projectRange") ? ((Parameter)param.getParams().get("projectRange")).getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? ((Parameter)param.getParams().get("dateIn")).getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");
        if (StringUtils.isNotBlank((CharSequence)projectRange) || StringUtils.isNotBlank((CharSequence)dateIn)) {
            CommonResponse projectIdsResp = this.projectPoolApi.queryProjectIdsByorgId(orgId, projectRange, dateIn);
            if (!projectIdsResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u5931\u8d25, {}", (Object)orgId, (Object)JSONObject.toJSONString((Object)projectIdsResp));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)projectIdsResp.getData()))) {
                param.getParams().put("projectId", new Parameter("in", projectIdsResp.getData()));
            } else {
                this.logger.info("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u4e3a\u7a7a, \u5219\u8fd4\u56de\u7a7a\u7684\u6570\u636e\u5217\u8868\uff01", (Object)orgId);
                resp.put("current", (Object)param.getPageIndex());
                resp.put("size", (Object)param.getPageSize());
                resp.put("pages", (Object)0);
                resp.put("totalMny", (Object)0);
                resp.put("total", (Object)0);
                resp.put("records", new ArrayList());
                return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
            }
        }
        if (null != param.getParams().get("projectSettleFlag")) {
            if ("true".equals(((Parameter)param.getParams().get("projectSettleFlag")).getValue().toString())) {
                CommonResponse paramResponse = this.paramConfigApi.getByCode(this.PROJECT_SETTLE_RANGE_PARAM);
                if (!paramResponse.isSuccess() || paramResponse.getData() == null) {
                    throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u7ed3\u7b97\u67e5\u8be2\u7ed3\u7b97\u5355\u8303\u56f4\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + paramResponse.getMsg());
                }
                String valueData = ((ParamRegisterSetVO)paramResponse.getData()).getValueData();
                Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u9879\u76ee\u7ed3\u7b97\u67e5\u8be2\u7ed3\u7b97\u5355\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
                param.getParams().put("sourceType", new Parameter("in", (Object)valueData));
            }
            param.getParams().remove("projectSettleFlag");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List settlePoolVOList = BeanMapper.mapList((Iterable)page.getRecords(), SettlePoolVO.class);
        settlePoolVOList.forEach(vo -> {
            vo.setSourceTypeName(null != SettleSourceTypeEnum.getByCode((String)vo.getSourceType()) ? SettleSourceTypeEnum.getByCode((String)vo.getSourceType()).getName() : null);
            Integer settleProperty = vo.getSettleProperty();
            vo.setSettlePropertyName("");
            if (settleProperty != null) {
                vo.setSettlePropertyName(1 == settleProperty ? "\u6536\u5165" : "\u652f\u51fa");
            }
            Integer contractFlag = vo.getContractFlag();
            vo.setContractFlagName("");
            if (contractFlag != null) {
                vo.setContractFlagName(1 == contractFlag ? "\u662f" : "\u5426");
            } else {
                vo.setContractFlagName("\u662f");
            }
        });
        pageData.setRecords(settlePoolVOList);
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("totalMny", (Object)this.service.calcTotalMny(param));
        resp.put("records", (Object)settlePoolVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<SettlePoolVO> queryDetail(Long id) {
        SettlePoolEntity entity = (SettlePoolEntity)((Object)this.service.selectById(id));
        SettlePoolVO vo = (SettlePoolVO)BeanMapper.map((Object)((Object)entity), SettlePoolVO.class);
        ArrayList paramList = Lists.newArrayList((Object[])new String[]{vo.getSourceType(), vo.getContractType(), "partya", "partyb", "project"});
        HashMap urlMap = new HashMap();
        List<BillUrlDictEntity> urlList = this.service.queryDetailUrlList(paramList);
        if (CollectionUtils.isNotEmpty(urlList)) {
            urlList.forEach(u -> urlMap.put(u.getSourceType(), u.getSourceDetailUrl()));
        }
        if (MapUtils.isNotEmpty(urlMap)) {
            vo.setBillCodeUrl((String)urlMap.get(vo.getSourceType()));
            vo.setContractUrl((String)urlMap.get(vo.getContractType()));
            vo.setPartyaUrl((String)urlMap.get("partya"));
            vo.setPartybUrl((String)urlMap.get("partyb"));
            vo.setProjectUrl((String)urlMap.get("project"));
        }
        vo.setSourceTypeName(SettleSourceTypeEnum.getByCode((String)vo.getSourceType()).getName());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "partyaName", "partybName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, SettlePoolVO.class);
            for (SettlePoolVO vo : voList) {
                if (vo == null) continue;
                vo.setSourceTypeName("");
                String sourceType = vo.getSourceType();
                if (StringUtils.isNotBlank((CharSequence)sourceType)) {
                    SettleSourceTypeEnum settleSourceTypeEnum = SettleSourceTypeEnum.getByCode((String)sourceType);
                    vo.setSourceTypeName(settleSourceTypeEnum != null ? settleSourceTypeEnum.getName() : "");
                }
                Integer settleProperty = vo.getSettleProperty();
                vo.setSettlePropertyName("");
                if (settleProperty != null) {
                    vo.setSettlePropertyName(1 == settleProperty ? "\u6536\u5165" : "\u652f\u51fa");
                }
                vo.setHandleTypeStr(Integer.valueOf(1).equals(vo.getHandleType()) ? "\u624b\u52a8\u8865\u5f55" : "\u4e1a\u52a1\u63a8\u9001");
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("SettlePool-export.xlsx", beans, response);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @GetMapping(value={"/refSettlePoolData"})
    public CommonResponse<IPage<SettlePoolVO>> refSettlePoolData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "partyaName", "partybName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            String excludeIdStr;
            String excludeSourceTypes;
            String sourceTypeStr;
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (condition.contains("contractId")) {
                param.getParams().put("contractId", new Parameter("eq", (Object)_con.getString("contractId")));
            }
            if (StringUtils.isNotBlank((CharSequence)(sourceTypeStr = _con.getString("sourceTypes")))) {
                param.getParams().put("source_type", new Parameter("in", (Object)Lists.newArrayList((Object[])sourceTypeStr.split(","))));
            }
            if (StringUtils.isNotBlank((CharSequence)(excludeSourceTypes = _con.getString("excludeSourceTypes")))) {
                param.getParams().put("source_type", new Parameter("not_in", (Object)Lists.newArrayList((Object[])excludeSourceTypes.split(","))));
            }
            if (condition.contains("projectId")) {
                param.getParams().put("projectId", new Parameter("eq", (Object)_con.getString("projectId")));
            }
            if (condition.contains("supplierId")) {
                param.getParams().put("partyb_id", new Parameter("eq", (Object)_con.getString("supplierId")));
            }
            if (StringUtils.isNotBlank((CharSequence)(excludeIdStr = _con.getString("excludeIds")))) {
                param.getParams().put("id", new Parameter("not_in", (Object)Lists.newArrayList((Object[])excludeIdStr.split(","))));
            }
        }
        param.getParams().put("residue_apply_mny", new Parameter("gt", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List settlePoolVOS = BeanMapper.mapList((Iterable)page.getRecords(), SettlePoolVO.class);
        for (SettlePoolVO vo : settlePoolVOS) {
            if (vo.getTotalSettlePaymentTaxMny() == null) {
                vo.setTotalSettlePaymentTaxMny(vo.getCurTaxMny());
                vo.setTotalSettlePaymentMny(vo.getCurMny());
            }
            String sourceType = vo.getSourceType();
            if ("labor_node".equals(vo.getSourceType()) || "pro_node".equals(vo.getSourceType())) {
                vo.setSourceTypeNameStr("\u8282\u70b9\u7ed3\u7b97");
                continue;
            }
            if ("labor_final".equals(vo.getSourceType()) || "pro_final".equals(vo.getSourceType())) {
                vo.setSourceTypeNameStr("\u6700\u7ec8\u7ed3\u7b97");
                continue;
            }
            if (vo.getUltimateFlag() == null || 1 != vo.getUltimateFlag()) {
                vo.setSourceTypeNameStr("\u8fc7\u7a0b\u7ed3\u7b97");
                continue;
            }
            vo.setSourceTypeNameStr("\u6700\u7ec8\u7ed3\u7b97");
        }
        pageData.setRecords(settlePoolVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryTotalMny"}, method={RequestMethod.POST})
    public CommonResponse<SettlePoolVO> queryTotalMny(@RequestBody SettlePoolVO settlePoolVO) {
        return CommonResponse.success((Object)this.service.queryTotalMny(settlePoolVO));
    }

    @RequestMapping(value={"/queryContractSettleList"}, method={RequestMethod.POST})
    public CommonResponse<JSONObject> queryContractSettleList(@RequestBody SettlePoolVO settlePoolVO) {
        ArrayList<String> typeList;
        JSONObject resp = new JSONObject();
        QueryParam queryParam = new QueryParam();
        if (null != settlePoolVO.getContractId()) {
            queryParam.getParams().put("contract_id", new Parameter("eq", (Object)settlePoolVO.getContractId()));
        }
        if (null != settlePoolVO.getContractType()) {
            queryParam.getParams().put("contractType", new Parameter("eq", (Object)settlePoolVO.getContractType()));
        }
        if (null != settlePoolVO.getProjectId()) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)settlePoolVO.getProjectId()));
        }
        if (ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode().equals(settlePoolVO.getContractType())) {
            typeList = new ArrayList<String>();
            typeList.add(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode());
            typeList.add(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u8282\u70b9\u7ed3\u7b97.getCode());
            queryParam.getParams().put("source_type", new Parameter("in", typeList));
        }
        if (ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(settlePoolVO.getContractType())) {
            typeList = new ArrayList();
            typeList.add(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode());
            typeList.add(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u8282\u70b9\u7ed3\u7b97.getCode());
            queryParam.getParams().put("source_type", new Parameter("in", typeList));
        }
        queryParam.getOrderMap().put("settleDate", "desc");
        List settleList = this.service.queryList(queryParam, false);
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal totalMny = BigDecimal.ZERO;
        for (SettlePoolEntity entity : settleList) {
            if (SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode().equals(entity.getSourceType()) || SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode().equals(entity.getSourceType())) {
                if (entity.getTotalNodeTaxDifference() != null) {
                    totalTaxMny = totalTaxMny.add(entity.getTotalNodeTaxDifference());
                }
                if (null == entity.getTotalNodeDifference()) continue;
                totalMny = totalMny.add(entity.getTotalNodeDifference());
                continue;
            }
            totalTaxMny = totalTaxMny.add(entity.getCurTaxMny());
            totalMny = totalMny.add(entity.getCurMny());
        }
        resp.put("totalSettleTaxMny", (Object)totalTaxMny);
        resp.put("totalSettleMny", (Object)totalMny);
        resp.put("settleList", (Object)settleList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)resp);
    }

    @GetMapping(value={"/queryLaborMny"})
    public CommonResponse<Map<String, BigDecimal>> queryLaborMny(@RequestParam(value="contractId") String contractId) {
        this.logger.info("ejc-contractbase-impl***SettlePoolController***queryLaborMny\u65b9\u6cd5***begin***contractId-{}", (Object)contractId);
        Map<String, BigDecimal> response = this.service.queryLaborMny(Long.parseLong(contractId));
        this.logger.info("ejc-contractbase-impl***SettlePoolController***queryLaborMny\u65b9\u6cd5***end***\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString(response));
        return CommonResponse.success(response);
    }

    @RequestMapping(value={"/downloadExcelModel"})
    @ResponseBody
    public void downloadExcelModel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"SettlePool-import-template.xlsx", (String)"\u7ed3\u7b97\u6c60-\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }

    @RequestMapping(value={"/calcTotalMny"}, method={RequestMethod.POST})
    public CommonResponse<BigDecimal> calcTotalMny(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "partyaName", "partybName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = null;
        String orgType = null;
        if (null != param.getParams().get("orgId") && null != param.getParams().get("orgType")) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgType = ((Parameter)param.getParams().get("orgType")).getValue().toString();
            param.getParams().remove("orgId");
            param.getParams().remove("orgType");
        } else {
            orgType = InvocationInfoProxy.getOrgType();
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(orgType))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u6210\u529f\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        String projectRange = null != param.getParams().get("projectRange") ? ((Parameter)param.getParams().get("projectRange")).getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? ((Parameter)param.getParams().get("dateIn")).getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");
        if (StringUtils.isNotBlank((CharSequence)projectRange) || StringUtils.isNotBlank((CharSequence)dateIn)) {
            CommonResponse projectIdsResp = this.projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(), projectRange, dateIn);
            if (!projectIdsResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)projectIdsResp));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)projectIdsResp.getData()))) {
                param.getParams().put("projectId", new Parameter("in", projectIdsResp.getData()));
            } else {
                this.logger.info("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u4e3a\u7a7a, \u5219\u8fd4\u56de\u7a7a\u7684\u6570\u636e\u5217\u8868\uff01");
                return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BigDecimal.ZERO);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.calcTotalMny(param));
    }
}

