/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.entity.TemplateEntity;
import com.ejianc.business.contractbase.entity.TemplateVersionEntity;
import com.ejianc.business.contractbase.mapper.TemplateVersionMapper;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.service.ITemplateVersionService;
import com.ejianc.business.contractbase.vo.TemplateVersionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateVersionServiceImpl
extends BaseServiceImpl<TemplateVersionMapper, TemplateVersionEntity>
implements ITemplateVersionService {
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private IAttachmentApi attachmentApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TemplateVersionVO newTemplateVersion(TemplateVersionVO templateVersionVO) {
        TemplateEntity templateEntity = (TemplateEntity)((Object)this.templateService.selectById(templateVersionVO.getTemplateId()));
        TemplateVersionEntity tee = (TemplateVersionEntity)((Object)BeanMapper.map((Object)templateVersionVO, TemplateVersionEntity.class));
        tee.setCategoryName(templateEntity.getCategoryName());
        tee.setCategoryId(templateEntity.getCategoryId());
        tee.setTenantId(templateEntity.getTenantId());
        tee.setTemplateName(templateEntity.getTemplateName());
        tee.setBillTypeCode(templateEntity.getBillTypeCode());
        tee.setMetadata(templateEntity.getMetadata());
        tee.setId(IdWorker.getId());
        templateEntity.setFileId(tee.getFileId());
        templateEntity.setFilePath(tee.getFilePath());
        templateEntity.setFileName(tee.getFileName());
        templateEntity.setFileSize(tee.getFileSize());
        templateEntity.setFileType(tee.getFileType());
        templateEntity.setCurVersionId(tee.getId());
        templateEntity.setCurVersion(tee.getTemplateVersion());
        CommonResponse copyResp = this.attachmentApi.copyFile(tee.getFileId().toString(), tee.getId().toString(), "BT211109000000002", "template", false);
        if (!copyResp.isSuccess()) {
            this.logger.error("\u521b\u5efa\u6a21\u677f{} \u7248\u672c\u4fe1\u606f\u5931\u8d25, \u6a21\u677f\u6587\u4ef6\u62f7\u8d1d\u5931\u8d25: {}", (Object)JSONObject.toJSONString((Object)templateVersionVO), (Object)JSONObject.toJSONString((Object)copyResp));
            throw new BusinessException("\u521b\u5efa\u6a21\u677f\u7248\u672c\u4fe1\u606f\u5931\u8d25, \u6a21\u677f\u6587\u4ef6\u62f7\u8d1d\u5931\u8d25");
        }
        AttachmentVO attach = (AttachmentVO)copyResp.getData();
        tee.setFileId(attach.getId());
        tee.setFileName(attach.getFileName());
        tee.setFileSize(attach.getFileSize().intValue());
        tee.setFilePath(attach.getFilePath());
        super.saveOrUpdate((Object)tee, false);
        this.templateService.saveOrUpdate((Object)templateEntity, false);
        return (TemplateVersionVO)BeanMapper.map((Object)((Object)tee), TemplateVersionVO.class);
    }

    @Override
    public TemplateVersionEntity createVersion(TemplateEntity entity) {
        TemplateVersionEntity map = (TemplateVersionEntity)((Object)BeanMapper.map((Object)((Object)entity), TemplateVersionEntity.class));
        map.setAttachIds(new ArrayList());
        map.setTemplateId(entity.getId());
        map.setTemplateVersion(1L);
        map.setId(IdWorker.getId());
        if (null != entity.getFileId()) {
            CommonResponse copyResp = this.attachmentApi.copyFile(entity.getFileId().toString(), map.getId().toString(), "BT211109000000002", "template", false);
            if (!copyResp.isSuccess()) {
                this.logger.error("\u521b\u5efa\u6a21\u677f{} \u7248\u672c\u4fe1\u606f\u5931\u8d25, \u6a21\u677f\u6587\u4ef6\u62f7\u8d1d\u5931\u8d25: {}", (Object)JSONObject.toJSONString((Object)((Object)entity)), (Object)JSONObject.toJSONString((Object)copyResp));
                throw new BusinessException("\u521b\u5efa\u6a21\u677f\u7248\u672c\u4fe1\u606f\u5931\u8d25, \u6a21\u677f\u6587\u4ef6\u62f7\u8d1d\u5931\u8d25");
            }
            AttachmentVO attach = (AttachmentVO)copyResp.getData();
            map.setFileId(attach.getId());
            map.setFileName(attach.getFileName());
            map.setFileSize(attach.getFileSize().intValue());
            map.setFilePath(attach.getFilePath());
        }
        this.saveOrUpdate((Object)map, false);
        return map;
    }

    @Override
    public TemplateVersionEntity updateVersion(TemplateEntity entity) {
        TemplateVersionEntity versionEntity = (TemplateVersionEntity)((Object)this.selectById(entity.getCurVersionId()));
        versionEntity.setFileSize(entity.getFileSize());
        versionEntity.setOnlinePath(entity.getOnlinePath());
        versionEntity.setFileName(entity.getFileName());
        versionEntity.setTemplateName(entity.getTemplateName());
        versionEntity.setFileType(entity.getFileType());
        versionEntity.setCategoryName(entity.getCategoryName());
        versionEntity.setCategoryId(entity.getCategoryId());
        versionEntity.setFileId(entity.getFileId());
        versionEntity.setMetadata(entity.getMetadata());
        this.saveOrUpdate((Object)versionEntity, false);
        return versionEntity;
    }
}

