package com.ejianc.business.contractbase.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.entity.CategoryRelationEntity;
import com.ejianc.business.contractbase.entity.ClauseSettingEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.service.ICategoryRelationService;
import com.ejianc.business.contractbase.service.IClauseSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2022/1/6 17:03
 */
@RestController
@RequestMapping
public class ClauseSettingApi {

    @Autowired
    private IClauseSettingService clauseSettingService;

    @Autowired
    private ICategoryRelationService relationService;

    @Autowired
    private ITemplateCategoryService templateCategoryService;

    /**
     * 根据模板Id查询可用条款列表
     *
     * @param categoryId 合同分类id
     * @return
     */
    @GetMapping(value = "/api/clauseSetting/getListByCategoryId")
    public CommonResponse<List<ClauseSettingVO>> getListByCategoryId(@RequestParam Long categoryId) {
        return getClasuseList(templateCategoryService.selectById(categoryId));
    }

    /**
     * 根据分类属性查询对应可用条款列表
     *
     * @param categoryProperty
     * @return
     */
    @GetMapping(value = "/api/clauseSetting/getListByCategoryProperty")
    public CommonResponse<List<ClauseSettingVO>> getListByCategoryProperty(@RequestParam String categoryProperty) {
        QueryWrapper<TemplateCategoryEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("is_top", 0);
        query.eq("category_property", categoryProperty);
        TemplateCategoryEntity category = templateCategoryService.getOne(query);

        return getClasuseList(category);
    }

    private CommonResponse<List<ClauseSettingVO>> getClasuseList(TemplateCategoryEntity templateCategoryEntity) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId",new Parameter("eq", InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("enableStatus",new Parameter("eq","1"));

        //查询设置可用范围的分类id
        QueryWrapper<CategoryRelationEntity> query = new QueryWrapper<>();
        query.eq("dr", 0);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.likeRight("category_inner_code", templateCategoryEntity.getInnerCode());
        List<CategoryRelationEntity> categoryRelationEntities = relationService.list(query);

        if(CollectionUtils.isNotEmpty(categoryRelationEntities)){
            ComplexParam c1 = new ComplexParam();
            c1.setLogic(ComplexParam.AND);
            ComplexParam c2 = new ComplexParam();
            c2.setLogic(ComplexParam.OR);
            c2.getParams().put("id",new Parameter(QueryParam.IN,categoryRelationEntities.stream().map(CategoryRelationEntity::getClauseId).collect(Collectors.toList())));
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("enableType",new Parameter("eq",1));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            queryParam.getComplexParams().add(c1);
        } else {
            queryParam.getParams().put("enableType",new Parameter("eq",1));
        }

        List<ClauseSettingEntity> list = clauseSettingService.queryList(queryParam, false);

        return CommonResponse.success(BeanMapper.mapList(list, ClauseSettingVO.class));
    }

}
