package com.ejianc.business.contractbase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.entity.TemplateEntity;
import com.ejianc.business.contractbase.entity.TemplateSignatoryRectEntity;
import com.ejianc.business.contractbase.entity.TemplateVersionEntity;
import com.ejianc.business.contractbase.mapper.TemplateMapper;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.service.ITemplateSignatoryRectService;
import com.ejianc.business.contractbase.service.ITemplateVersionService;
import com.ejianc.business.contractbase.vo.TemplateVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author:刘家乐
 * @version:
 * @date:2021/11/9
 * @document:
 */
@Service
public class TemplateServiceImpl extends BaseServiceImpl<TemplateMapper, TemplateEntity> implements ITemplateService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    /**此处需要根据实际修改*/
    private static final String BILL_CODE = "LJL_TEMPLATE";

    @Autowired
    private ITemplateVersionService versionService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ITemplateSignatoryRectService templateSignatoryRectService;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<TemplateVO> returnCommon(Long id) {
        TemplateEntity entity = this.selectById(id);
        TemplateVO templateVO = BeanMapper.map(entity, TemplateVO.class);
        return CommonResponse.success(templateVO);
    }

    @Override
    public TemplateVO saveCopyTempl(TemplateVO copyVo) {
        TemplateEntity sourceDbEntity = super.selectById(copyVo.getId());
        TemplateEntity newTeTmpl = BeanMapper.map(copyVo, TemplateEntity.class);

        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()){
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        //清空Id
        newTeTmpl.setId(IdWorker.getId());
        newTeTmpl.setTenantId(sourceDbEntity.getTenantId());
        newTeTmpl.setQrCodePagePosition(sourceDbEntity.getQrCodePagePosition());
        newTeTmpl.setQrCodeShowType(sourceDbEntity.getQrCodeShowType());
        newTeTmpl.setQrCodeFlag(sourceDbEntity.getQrCodeFlag());
        newTeTmpl.setBillTypeCode(sourceDbEntity.getBillTypeCode());
        newTeTmpl.setCode(billCode.getData());
        //复制的模板默认不启用
        newTeTmpl.setEnableStatus(TemplateVO.STATUS_DISABLE);

        //复制文件
        CommonResponse<AttachmentVO> copyResp = attachmentApi.copyFile(sourceDbEntity.getFileId().toString(), newTeTmpl.getId().toString(),
                "BT211109000000002", "concractFiles", false);
        if(!copyResp.isSuccess()) {
            logger.error("模板文件-{}, 复制到单据-{}下失败，返回结果：{}",sourceDbEntity.getFileId(), newTeTmpl.getId(), JSONObject.toJSONString(copyResp));
            throw new BusinessException("模板复制失败，模板文件复制失败！");
        }

        //设置文件信息
        AttachmentVO newFile = copyResp.getData();
        newTeTmpl.setFileId(newFile.getId());
        newTeTmpl.setOnlinePath(newFile.getOnlinePath());
        newTeTmpl.setFileSize(Integer.valueOf(newFile.getFileSize().toString()));
        newTeTmpl.setFilePath(newFile.getFilePath());
        newTeTmpl.setFileName(newFile.getFileName());

        if(null != newTeTmpl.getBelongOrgId()) {
            CommonResponse<OrgVO> orgResp = orgApi.getOneById(newTeTmpl.getBelongOrgId());
            if(!orgResp.isSuccess()) {
                throw new BusinessException("保存失败，获取组织信息失败！");
            }
            newTeTmpl.setBelongOrgInnerCode(orgResp.getData().getInnerCode());
        }

        //创建合同模板 版本信息
        TemplateVersionEntity version = versionService.createVersion(newTeTmpl);
        newTeTmpl.setCurVersionId(version.getId());
        newTeTmpl.setCurVersion(1L);

        //复制签章定位信息
        LambdaQueryWrapper<TemplateSignatoryRectEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TemplateSignatoryRectEntity::getDr, 0);
        queryWrapper.eq(TemplateSignatoryRectEntity::getTemplateId, sourceDbEntity.getId());
        queryWrapper.orderByAsc(TemplateSignatoryRectEntity::getPartyCode);
        List<TemplateSignatoryRectEntity> entityList = templateSignatoryRectService.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(entityList)) {
            List<TemplateSignatoryRectEntity> newSignList = BeanMapper.mapList(entityList, TemplateSignatoryRectEntity.class);
            newSignList.stream().forEach((item) -> {
                item.setId(IdWorker.getId());
                item.setTemplateId(newTeTmpl.getId());
            });

            templateSignatoryRectService.saveOrUpdateBatch(newSignList, newSignList.size(), false);
        }

        super.saveOrUpdate(newTeTmpl, false);
        return BeanMapper.map(newTeTmpl, TemplateVO.class);
    }
}
