/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.entity.CategoryRelationEntity;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.service.ICategoryRelationService;
import com.ejianc.business.contractbase.service.IClauseSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class ClauseSettingApi {
    @Autowired
    private IClauseSettingService clauseSettingService;
    @Autowired
    private ICategoryRelationService relationService;
    @Autowired
    private ITemplateCategoryService templateCategoryService;

    @GetMapping(value={"/api/clauseSetting/getListByCategoryId"})
    public CommonResponse<List<ClauseSettingVO>> getListByCategoryId(@RequestParam Long categoryId) {
        return this.getClasuseList((TemplateCategoryEntity)((Object)this.templateCategoryService.selectById(categoryId)));
    }

    @GetMapping(value={"/api/clauseSetting/getListByCategoryProperty"})
    public CommonResponse<List<ClauseSettingVO>> getListByCategoryProperty(@RequestParam String categoryProperty) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"is_top", (Object)0);
        query.eq((Object)"category_property", (Object)categoryProperty);
        TemplateCategoryEntity category = (TemplateCategoryEntity)((Object)this.templateCategoryService.getOne((Wrapper)query));
        return this.getClasuseList(category);
    }

    private CommonResponse<List<ClauseSettingVO>> getClasuseList(TemplateCategoryEntity templateCategoryEntity) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("enableStatus", new Parameter("eq", (Object)"1"));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)0);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.likeRight((Object)"category_inner_code", (Object)templateCategoryEntity.getInnerCode());
        List categoryRelationEntities = this.relationService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)categoryRelationEntities)) {
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("id", new Parameter("in", categoryRelationEntities.stream().map(CategoryRelationEntity::getClauseId).collect(Collectors.toList())));
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("enableType", new Parameter("eq", (Object)1));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            queryParam.getComplexParams().add(c1);
        } else {
            queryParam.getParams().put("enableType", new Parameter("eq", (Object)1));
        }
        List list = this.clauseSettingService.queryList(queryParam, false);
        return CommonResponse.success((Object)BeanMapper.mapList((Iterable)list, ClauseSettingVO.class));
    }
}

