package com.ejianc.business.contractbase.check.controller.api;


import com.ejianc.business.contractbase.check.service.IParamCheckService;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;

@RestController
@RequestMapping("/api/paramCheck")
public class ParamCheckApi {

    @Autowired
    private IParamCheckService paramCheckService;

//    @GetMapping("/contratCheck")
//    public CommonResponse<ParamsCheckVO> paramsCheck(@RequestParam("projectId") Long projectId, @RequestParam(value = "contractId",required = false)Long contractId, @RequestParam("contractTaxMny")BigDecimal contractTaxMny){
//        return CommonResponse.success(paramCheckService.paramsCheck(projectId,contractId,contractTaxMny));
//    }

    @GetMapping("/contratCheck")
    public CommonResponse<List<ParamsCheckVO>> paramsCheck(@RequestParam("projectId") Long projectId, @RequestParam(value = "contractId",required = false)Long contractId,
                                                           @RequestParam("contractTaxMny")BigDecimal contractTaxMny, @RequestParam("orgId") Long orgId){
        return CommonResponse.success(paramCheckService.paramsCheck(projectId,contractId,contractTaxMny, orgId));
    }



}
