package com.ejianc.business.contractbase.filing.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.filing.entity.ContractFilingEntity;
import com.ejianc.business.contractbase.filing.entity.FilingTypeEntity;
import com.ejianc.business.contractbase.filing.service.IContractFilingService;
import com.ejianc.business.contractbase.filing.service.IFilingTypeService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author CJ
 * @Description:
 * @date 2022/7/28 18:22
 */
@RestController
@RequestMapping
public class ContractFillingApiController {

    @Autowired
    private IFilingTypeService filingTypeService;

    @Autowired
    private IContractFilingService contractFilingService;

    @PostMapping(value = "/api/contractfiling/updateFilingStatus")
    CommonResponse<String> updateFilingStatus(@RequestBody String updateParamJson) {
        JSONObject param = JSONObject.parseObject(updateParamJson);
        if(null == param.get("fillingType")) {
            return CommonResponse.error("归档类型参数-【fillingType】为空");
        }
        if(null == param.get("billId")) {
            return CommonResponse.error("归档单据Id参数-【billId】为空");
        }
        if(null == param.get("status")) {
            return CommonResponse.error("归档状态参数-【status】为空");
        }

        QueryWrapper<FilingTypeEntity> query = new QueryWrapper<>();
        query.eq("contract_sub_type", param.get("fillingType").toString());
        FilingTypeEntity fillingType = filingTypeService.getOne(query);

        if(null == fillingType) {
            return CommonResponse.error("更新归档状态失败，没有匹配的归档类型！");
        }

        ContractFilingEntity contractFilingEntity = new ContractFilingEntity();
        contractFilingEntity.setSourceId(Long.valueOf(param.get("billId").toString()));
        contractFilingEntity.setFilingTypeName(fillingType.getFilingTypeName());
        contractFilingEntity.setUpdateBillType(fillingType.getSourceUpdateBillType());

        contractFilingService.updateFilingStatus(contractFilingEntity, Integer.valueOf(param.get("status").toString()), 0);

        return CommonResponse.success("设置归档状态成功！");
    }

}
