/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.pool.contractpool.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contractPreview/"})
public class ContractPreviewController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private IMdAttributeApi mdAttributeApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    @GetMapping(value={"queryDetail"})
    public CommonResponse<JSONObject> queryDetail(@RequestParam Long id, @RequestParam String billType, HttpServletRequest request) throws Exception {
        JSONObject resp = new JSONObject();
        String authority = request.getHeader("authority");
        CommonResponse billTypeVo = this.billTypeApi.getByCode(billType);
        if (!billTypeVo.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u3010code: {}\u3011\u4fe1\u606f\u5931\u8d25\uff01", (Object)billType);
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        CommonResponse mdResp = this.mdApi.queryMetadataById(((BillTypeVO)billTypeVo.getData()).getMetadataId());
        if (!mdResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u6839\u636e\u5143\u6570\u636eId\u3010{}\u3011\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff01", (Object)((BillTypeVO)billTypeVo.getData()).getMetadataId());
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        MdReferVO mdReferVO = (MdReferVO)mdResp.getData();
        String url = this.BaseHost + mdReferVO.getProjectName() + "/commonstate/queryBillDetail";
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        params.put("billId", id.toString());
        params.put("tableName", mdReferVO.getTableName());
        params.put("metadataId", mdReferVO.getMetadataId().toString());
        headers.put("content-type", "application/json;charset=UTF-8");
        headers.put("authority", authority);
        this.logger.info("\u53d1\u9001\u8bf7\u6c42url-{},\u53c2\u6570-{},header-{} \u83b7\u53d6\u5355\u636e\u8be6\u60c5", new Object[]{url, JSONObject.toJSONString(params), JSONObject.toJSONString(headers)});
        String detailReqStr = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(params), headers, (Integer)10000, (Integer)10000);
        this.logger.info("\u83b7\u53d6\u5355\u636e\u8be6\u60c5\u7ed3\u679c\uff1a{}", (Object)detailReqStr);
        CommonResponse detailResp = (CommonResponse)JSONObject.parseObject((String)detailReqStr, CommonResponse.class);
        if (!detailResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25, \u53d1\u9001\u8bf7\u6c42url-{},\u53c2\u6570-{},header-{} \u83b7\u53d6\u5355\u636e\u8be6\u60c5\u5931\u8d25", new Object[]{url, JSONObject.toJSONString(params), JSONObject.toJSONString(headers)});
            return CommonResponse.error((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25, \u67e5\u8be2\u5355\u636e\u8be6\u60c5\u5931\u8d25\uff01");
        }
        resp = JSONObject.parseObject((String)JSONObject.toJSONString((Object)detailResp.getData()));
        CommonResponse attrResp = this.mdAttributeApi.queryAttrInfoByAttName(mdReferVO.getMetadataId(), "qrCode");
        if (!attrResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25, \u6839\u636e\u5143\u6570\u636eId-{},\u67e5\u8be2\u5b57\u6bb5-\u3010qrCode\u3011\u4fe1\u606f\u5931\u8d25\uff01", (Object)mdReferVO.getMetadataId().toString());
            return CommonResponse.error((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25, \u83b7\u53d6\u5355\u636e\u5c5e\u6027\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null == attrResp.getData() || StringUtils.isBlank((CharSequence)((MdAttributeVO)attrResp.getData()).getDataFormat())) {
            this.logger.error("\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25, \u6839\u636e\u5143\u6570\u636eId-{},\u67e5\u8be2\u5b57\u6bb5-\u3010qrCode\u3011\u4fe1\u606f\u5931\u8d25\uff01", (Object)mdReferVO.getMetadataId().toString());
            return CommonResponse.error((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25, \u83b7\u53d6\u5355\u636e\u5c5e\u6027\u4fe1\u606f\u5931\u8d25\uff01");
        }
        resp.put("billStateName", (Object)BillStateEnum.getEnumByStateCode((Integer)resp.getInteger("billState")).getDescription());
        resp.put("dataFormat", (Object)((MdAttributeVO)attrResp.getData()).getDataFormat());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

