/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.pool.contractpool.warn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractWarnDTO;
import com.ejianc.business.contractbase.pool.contractpool.mapper.ContractPoolMapper;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contractWarn/"})
public class ContractWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ContractPoolMapper mapper;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    static String PC_URL_EC = "/ejc-targetcost-frontend/#/execution?projectId=";
    static String TEST_AGENTID = "1000038";
    static String TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
    static String PRO_AGENTID = "1000036";
    static String PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";
    static String PC_URL = "/ejc-report-frontend/#/reportChat?tableCode=Excontracts?projectId=";
    static String PC_URL_COST = "/ejc-procost-frontend/#/costShare?projectId=";

    @PostMapping(value={"execute"})
    public CommonResponse<String> execute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<ContractWarnDTO> contractWarnDTOS = this.mapper.contractWarnList();
            if (!ListUtil.isNotEmpty(contractWarnDTOS)) continue;
            for (ContractWarnDTO assessDetailVO : contractWarnDTOS) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = assessDetailVO.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if (assessDetailVO.getPercent().compareTo(new BigDecimal(0.5)) >= 0) continue;
                    if (assessDetailVO.getDays() < 14) {
                        low = true;
                        useSetLow = set;
                        continue;
                    }
                    if (assessDetailVO.getDays() < 28) {
                        meddle = true;
                        useSetMeddle = set;
                        continue;
                    }
                    high = true;
                    useSetHigh = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                vo.setBillName(orgSet.getString("moduleName") + "-" + assessDetailVO.getName());
                vo.setPcTitle("\u652f\u51fa\u5408\u540c\u6ede\u540e");
                vo.setPcUrl(PC_URL + assessDetailVO.getProjectId());
                vo.setOrgId(assessDetailVO.getOrgId());
                vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                vo.setOrgName(assessDetailVO.getOrgName());
                vo.setSourceId(assessDetailVO.getProjectId().toString());
                vo.setTenantId(Long.valueOf(999999L));
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()).replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, 4) + ""));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()).replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, 4) + ""));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()).replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, 4) + ""));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"execute70"})
    public CommonResponse<String> execute70(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<ContractWarnDTO> contractWarnDTOS = this.mapper.contractWarnList();
            if (!ListUtil.isNotEmpty(contractWarnDTOS)) continue;
            for (ContractWarnDTO assessDetailVO : contractWarnDTOS) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = assessDetailVO.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if (assessDetailVO.getPercent().compareTo(new BigDecimal(0.5)) <= 0) continue;
                    if (assessDetailVO.getDays() < 14) {
                        low = true;
                        useSetLow = set;
                        continue;
                    }
                    if (assessDetailVO.getDays() < 28) {
                        meddle = true;
                        useSetMeddle = set;
                        continue;
                    }
                    high = true;
                    useSetHigh = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                vo.setBillName(orgSet.getString("moduleName") + "-" + assessDetailVO.getName());
                vo.setPcTitle("\u652f\u51fa\u5408\u540c\u6ede\u540e");
                vo.setPcUrl(PC_URL + assessDetailVO.getProjectId());
                vo.setOrgId(assessDetailVO.getOrgId());
                vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                vo.setOrgName(assessDetailVO.getOrgName());
                vo.setSourceId(assessDetailVO.getProjectId().toString());
                vo.setTenantId(Long.valueOf(999999L));
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()).replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, 4) + ""));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()).replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, 4) + ""));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()).replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, 4) + ""));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"executeCostWarn"})
    public CommonResponse<String> executeCostWarn(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<ContractWarnDTO> contractWarnDTOS = this.mapper.costWarnList();
            if (!ListUtil.isNotEmpty(contractWarnDTOS)) continue;
            for (ContractWarnDTO assessDetailVO : contractWarnDTOS) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = assessDetailVO.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if (assessDetailVO.getDays() < 14) {
                        low = true;
                        useSetLow = set;
                        continue;
                    }
                    if (assessDetailVO.getDays() < 28) {
                        meddle = true;
                        useSetMeddle = set;
                        continue;
                    }
                    high = true;
                    useSetHigh = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                vo.setBillName(orgSet.getString("moduleName") + "-" + assessDetailVO.getName());
                vo.setPcTitle("\u5408\u540c\u6ede\u540e-\u6210\u672c\u5f52\u96c6");
                vo.setPcUrl(PC_URL_COST + assessDetailVO.getProjectId());
                vo.setOrgId(assessDetailVO.getOrgId());
                vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                vo.setOrgName(assessDetailVO.getOrgName());
                vo.setSourceId(assessDetailVO.getProjectId().toString());
                vo.setTenantId(Long.valueOf(999999L));
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()).replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, 4) + ""));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()).replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, 4) + ""));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()).replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, 4) + ""));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"costShareWarn"})
    public CommonResponse<String> costShareWarn(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<ContractWarnDTO> contractWarnDTOS = this.mapper.costShareWarnList();
            if (!ListUtil.isNotEmpty(contractWarnDTOS)) continue;
            for (ContractWarnDTO assessDetailVO : contractWarnDTOS) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = assessDetailVO.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if (assessDetailVO.getDays() <= 2) {
                        low = true;
                        useSetLow = set;
                        continue;
                    }
                    if (assessDetailVO.getDays() <= 3) {
                        meddle = true;
                        useSetMeddle = set;
                        continue;
                    }
                    high = true;
                    useSetHigh = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + assessDetailVO.getName());
                vo.setPcTitle("\u6210\u672c\u5355\u636e\u672a\u5f52\u96c6");
                vo.setPcUrl(PC_URL_COST + assessDetailVO.getProjectId());
                vo.setOrgId(assessDetailVO.getOrgId());
                vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                vo.setOrgName(assessDetailVO.getOrgName());
                vo.setSourceId(assessDetailVO.getProjectId().toString());
                vo.setTenantId(Long.valueOf(999999L));
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", assessDetailVO.getName()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

