# 结算池 create.sql
/*
结算单类型：
product_value-产值报量,
product_value_first-对甲报量,
settle_verify-结算报审,
project_decide-工程定案,
material_week_rent_out-周转材租出结算,
material_week_rent_in-周转材租入结算,
equip_rent_out-设备租出结算,
equip_rent_in-设备租入结算,
labor_month-劳务分包月度结算,
labor_node-劳务分包节点结算,
labor_final-劳务分包最终结算,
pro_month-专业分包月度结算,
pro_node-专业分包节点结算,
pro_final-专业分包最终结算,
material_buy_in-物资采购结算,
equip_buy_in-设备采购结算,
beton_buy_in-混凝土采购结算,
temp_equip-临时设备结算,
big_equip_install_uninstall-大型设备安拆结算,
law_cost-诉讼费结算,
other_in-其他收入结算,
other_out-其他支出结算,
other_out_contract_month-其他支出合同过程结算,
material_week_rent_out_company-周转材租出结算（公司）,
material_week_rent_in_company-周转材租入结算（公司）,
material_week_buy_in_company-周转材采购结算（公司）,
equip_rent_out_company-设备组出结算（公司）,
equip_rent_in_company-设备组出入结算（公司）,
other_out_contract_final-其他支出合同最终结算

*/
CREATE TABLE `ejc_conbase_settle_pool`
(
    `id`                bigint(20) NOT NULL COMMENT '主键ID',
    `create_user_code`  varchar(64)    DEFAULT NULL COMMENT '创建者账号',
    `create_user_name`  varchar(64)    DEFAULT NULL COMMENT '创建者名称',
    `create_time`       datetime       DEFAULT NULL COMMENT '创建时间',
    `update_user_code`  varchar(64)    DEFAULT NULL COMMENT '修改者账号',
    `update_user_name`  varchar(64)    DEFAULT NULL COMMENT '修改者名称',
    `update_time`       datetime       DEFAULT NULL COMMENT '修改时间',
    `dr`                tinyint(4)     DEFAULT NULL COMMENT '逻辑删除标识',
    `tenant_id`         bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `sync_es_flag`      tinyint(4)     DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
    `version`           int(11)        DEFAULT NULL COMMENT '乐观锁',
    `source_id`         bigint(20)     DEFAULT NULL COMMENT '结算单来源',
    `source_type`       varchar(64)    DEFAULT NULL COMMENT '结算单类型：product_value-产值报量,product_value_first-对甲报量,settle_verify-结算报审,project_decide-工程定案,material_week_rent_out-周转材租出结算,material_week_rent_in-周转材租入结算,equip_rent_out-设备租出结算,equip_rent_in-设备租入结算,labor_month-劳务分包月度结算,labor_node-劳务分包节点结算,labor_final-劳务分包最终结算,pro_month-专业分包月度结算,pro_node-专业分包节点结算,pro_final-专业分包最终结算,material_buy_in-物资采购结算,equip_buy_in-设备采购结算,beton_buy_in-混凝土采购结算,temp_equip-临时设备结算,big_equip_install_uninstall-大型设备安拆结算,law_cost-诉讼费结算,other_in-其他收入结算,other_out-其他支出结算',
    `settle_property`   tinyint(4)     DEFAULT NULL COMMENT '属性类别，0支出，1收入',
    `bill_code`         varchar(50)    DEFAULT NULL COMMENT '单据编码',
    `bill_state`        tinyint(4)     DEFAULT NULL COMMENT '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
    `bill_state_name`   varchar(64)    DEFAULT NULL COMMENT '单据状态名称 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
    `org_id`            bigint(20)     DEFAULT NULL COMMENT '项目部id',
    `org_code`          varchar(50)    DEFAULT NULL COMMENT '项目部编码',
    `org_name`          varchar(128)   DEFAULT NULL COMMENT '项目部名称',
    `parent_org_id`     bigint(20)     DEFAULT NULL COMMENT '项目部所属组织id',
    `parent_org_code`   varchar(64)    DEFAULT NULL COMMENT '项目部所属组织编码',
    `parent_org_name`   varchar(128)   DEFAULT NULL COMMENT '项目部所属组织名称',
    `project_id`        bigint(20)     DEFAULT NULL COMMENT '项目Id',
    `project_name`      varchar(50)    DEFAULT NULL COMMENT '项目名称',
    `project_code`      varchar(64)    DEFAULT NULL COMMENT '项目编号',
    `contract_id`       bigint(20)     DEFAULT NULL COMMENT '合同id',
    `contract_name`     varchar(50)    DEFAULT NULL COMMENT '合同名称',
    `contract_code`     varchar(64)    DEFAULT NULL COMMENT '合同编码',
    `contract_type`     varchar(64)    DEFAULT NULL COMMENT '合同类型：contraction-施工合同，prosub-专业分包合同，laborsub-劳务分包合同，materialPurchase-物资采购合同，concrete-混凝土合同，otherIn-其他收入合同，otherOut-其他支出合同，equipmentPurchase-设备采购合同，equipmentRent-设备租赁合同，promat-周转材合同',
    `supplement_flag`   tinyint(4)     DEFAULT NULL COMMENT '合同类别：0-主合同 1-补充协议',
    `mai_contract_id`   bigint(20)     DEFAULT NULL COMMENT '主合同id',
    `mai_contract_name` varchar(50)    DEFAULT NULL COMMENT '主合同名称',
    `mai_contract_code` varchar(64)    DEFAULT NULL COMMENT '主合同编码',
    `partya_code`       varchar(64)    DEFAULT NULL COMMENT '甲方编码',
    `partya_id`         bigint(20)     DEFAULT NULL COMMENT '甲方id',
    `partya_name`       varchar(64)    DEFAULT NULL COMMENT '甲方名称',
    `partyb_code`       varchar(64)    DEFAULT NULL COMMENT '乙方编码',
    `partyb_id`         bigint(20)     DEFAULT NULL COMMENT '乙方id',
    `partyb_name`       varchar(50)    DEFAULT NULL COMMENT '乙方名称',
    `settle_date`       datetime       DEFAULT NULL COMMENT '结算日期',
    `cur_tax_mny`       decimal(28, 8) DEFAULT NULL COMMENT '本期结算金额:分包清单金额—领料扣款金额+零工登记金额+奖罚单金额+其他费用金额',
    `cur_mny`           decimal(28, 8) DEFAULT NULL COMMENT '本期结算金额(无税)',
    `cur_tax`           decimal(28, 8) DEFAULT NULL COMMENT '本期结算税额',
    `ultimate_flag`     tinyint(4)     DEFAULT NULL COMMENT '是否最终结算：0否，1是',
    `employee_id`       bigint(20)     DEFAULT NULL COMMENT '经办人id',
    `employee_name`     varchar(50)    DEFAULT NULL COMMENT '经办人名称',
    `department_id`     bigint(20)     DEFAULT NULL COMMENT '经办部门id',
    `department_name`   varchar(128)   DEFAULT NULL COMMENT '经办部门名称',
    `memo`              varchar(1024)  DEFAULT NULL COMMENT '非必填，0-500字',
    `last_tax_mny`      decimal(28, 8) DEFAULT NULL COMMENT '截止本期已结算金额:分包清单金额—领料扣款金额+零工登记金额+奖罚单金额+其他费用金额',
    `last_mny`          decimal(28, 8) DEFAULT NULL COMMENT '截止本期已结算金额(无税)',
    `last_tax`          decimal(28, 8) DEFAULT NULL COMMENT '截止本期税额',
    `sign_date`         datetime       DEFAULT NULL COMMENT '签订日期',
    `ext1`              varchar(255)   DEFAULT NULL COMMENT '扩展字段',
    `ext2`              varchar(255)   DEFAULT NULL COMMENT '扩展字段',
    `ext3`              varchar(255)   DEFAULT NULL COMMENT '扩展字段',
    `ext4`              varchar(255)   DEFAULT NULL COMMENT '扩展字段',
    `ext5`              varchar(255)   DEFAULT NULL COMMENT '扩展字段',
    `ext6`              varchar(255)   DEFAULT NULL COMMENT '扩展字段',
    `ext7`              varchar(255)   DEFAULT NULL COMMENT '扩展字段',
    `ext8`              varchar(255)   DEFAULT NULL COMMENT '扩展字段',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8 COMMENT ='结算池表';