/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.ClassPathResource;

public class ImportTemplate {
    private static HttpServletResponse httpResponse;

    public static void initialize(HttpServletResponse response) {
        try {
            httpResponse = response;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean templetdownload(HttpServletRequest request, String filename, String downfilename) {
        try {
            String ext = filename.substring(filename.lastIndexOf(".") + 1).toLowerCase();
            ClassPathResource resource = new ClassPathResource("excel/" + filename);
            InputStream inputStream = resource.getInputStream();
            downfilename = downfilename + "." + ext;
            ImportTemplate.getFile(inputStream, httpResponse, downfilename);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void getFile(InputStream inputStream, HttpServletResponse httpservletresponse, String downfilename) throws IOException {
        downfilename = downfilename.trim();
        httpservletresponse.setContentType("application/octet-stream");
        httpservletresponse.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(downfilename, "utf-8"));
        ServletOutputStream servletoutputstream1 = httpservletresponse.getOutputStream();
        ImportTemplate.dumpFile(inputStream, (OutputStream)servletoutputstream1, httpservletresponse);
        servletoutputstream1.flush();
        servletoutputstream1.close();
    }

    private static void dumpFile(InputStream inputStream, OutputStream outputstream, HttpServletResponse httpservletresponse) throws FileNotFoundException, IOException {
        int i;
        byte[] byteArr = new byte[4096];
        while ((i = inputStream.read(byteArr)) != -1) {
            outputstream.write(byteArr, 0, i);
        }
        inputStream.close();
    }
}

