/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.tree;

import com.ejianc.framework.core.tree.MultiTreeNode;
import com.ejianc.framework.core.tree.TraversalAction;
import com.ejianc.framework.core.tree.TreeNode;
import com.ejianc.framework.core.tree.TreeNodeException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class LinkedMultiTreeNode<T>
extends MultiTreeNode<T> {
    private static final long serialVersionUID = 1L;
    private LinkedMultiTreeNode<T> leftMostNode;
    private LinkedMultiTreeNode<T> rightSiblingNode;
    private LinkedMultiTreeNode<T> lastSubtreeNode;

    public LinkedMultiTreeNode(T data) {
        super(data);
    }

    @Override
    public Collection<? extends TreeNode<T>> subtrees() {
        if (this.isLeaf()) {
            return Collections.emptySet();
        }
        LinkedHashSet<LinkedMultiTreeNode<T>> subtrees = new LinkedHashSet<LinkedMultiTreeNode<T>>();
        subtrees.add(this.leftMostNode);
        LinkedMultiTreeNode<T> nextSubtree = this.leftMostNode.rightSiblingNode;
        while (nextSubtree != null) {
            subtrees.add(nextSubtree);
            nextSubtree = nextSubtree.rightSiblingNode;
        }
        return subtrees;
    }

    @Override
    public boolean add(TreeNode<T> subtree) {
        if (subtree == null) {
            return false;
        }
        LinkedMultiTreeNode.linkParent(subtree, this);
        if (this.isLeaf()) {
            this.leftMostNode = (LinkedMultiTreeNode)subtree;
            this.lastSubtreeNode = this.leftMostNode;
        } else {
            this.lastSubtreeNode.rightSiblingNode = (LinkedMultiTreeNode)subtree;
            this.lastSubtreeNode = this.lastSubtreeNode.rightSiblingNode;
        }
        return true;
    }

    @Override
    public boolean dropSubtree(TreeNode<T> subtree) {
        if (subtree == null || this.isLeaf() || subtree.isRoot()) {
            return false;
        }
        if (this.leftMostNode.equals(subtree)) {
            this.leftMostNode = this.leftMostNode.rightSiblingNode;
            LinkedMultiTreeNode.unlinkParent(subtree);
            ((LinkedMultiTreeNode)subtree).rightSiblingNode = null;
            return true;
        }
        LinkedMultiTreeNode<T> nextSubtree = this.leftMostNode;
        while (nextSubtree.rightSiblingNode != null) {
            if (nextSubtree.rightSiblingNode.equals(subtree)) {
                LinkedMultiTreeNode.unlinkParent(subtree);
                nextSubtree.rightSiblingNode = nextSubtree.rightSiblingNode.rightSiblingNode;
                ((LinkedMultiTreeNode)subtree).rightSiblingNode = null;
                return true;
            }
            nextSubtree = nextSubtree.rightSiblingNode;
        }
        return false;
    }

    @Override
    public void clear() {
        if (!this.isLeaf()) {
            LinkedMultiTreeNode<T> nextNode = this.leftMostNode;
            while (nextNode != null) {
                LinkedMultiTreeNode.unlinkParent(nextNode);
                LinkedMultiTreeNode<T> nextNodeRightSiblingNode = nextNode.rightSiblingNode;
                nextNode.rightSiblingNode = null;
                nextNode.lastSubtreeNode = null;
                nextNode = nextNodeRightSiblingNode;
            }
            this.leftMostNode = null;
        }
    }

    @Override
    public TreeNode.TreeNodeIterator iterator() {
        return new TreeNode.TreeNodeIterator(){

            @Override
            protected TreeNode<T> leftMostNode() {
                return LinkedMultiTreeNode.this.leftMostNode;
            }

            @Override
            protected TreeNode<T> rightSiblingNode() {
                return LinkedMultiTreeNode.this.rightSiblingNode;
            }
        };
    }

    @Override
    public boolean isLeaf() {
        return this.leftMostNode == null;
    }

    @Override
    public boolean hasSubtree(TreeNode<T> subtree) {
        if (subtree == null || this.isLeaf() || subtree.isRoot()) {
            return false;
        }
        LinkedMultiTreeNode<T> nextSubtree = this.leftMostNode;
        while (nextSubtree != null) {
            if (nextSubtree.equals(subtree)) {
                return true;
            }
            nextSubtree = nextSubtree.rightSiblingNode;
        }
        return false;
    }

    @Override
    public boolean contains(TreeNode<T> node) {
        if (node == null || this.isLeaf() || node.isRoot()) {
            return false;
        }
        LinkedMultiTreeNode<T> nextSubtree = this.leftMostNode;
        while (nextSubtree != null) {
            if (nextSubtree.equals(node)) {
                return true;
            }
            if (nextSubtree.contains(node)) {
                return true;
            }
            nextSubtree = nextSubtree.rightSiblingNode;
        }
        return false;
    }

    @Override
    public boolean remove(TreeNode<T> node) {
        if (node == null || this.isLeaf() || node.isRoot()) {
            return false;
        }
        if (this.dropSubtree(node)) {
            return true;
        }
        LinkedMultiTreeNode<T> nextSubtree = this.leftMostNode;
        while (nextSubtree != null) {
            if (nextSubtree.remove(node)) {
                return true;
            }
            nextSubtree = nextSubtree.rightSiblingNode;
        }
        return false;
    }

    @Override
    public void traversePreOrder(TraversalAction<TreeNode<T>> action) {
        if (!action.isCompleted()) {
            action.perform(this);
            if (!this.isLeaf()) {
                LinkedMultiTreeNode<LinkedMultiTreeNode> nextNode = this.leftMostNode;
                while (nextNode != null) {
                    nextNode.traversePreOrder(action);
                    nextNode = nextNode.rightSiblingNode;
                }
            }
        }
    }

    @Override
    public void traversePostOrder(TraversalAction<TreeNode<T>> action) {
        if (!action.isCompleted()) {
            if (!this.isLeaf()) {
                LinkedMultiTreeNode<T> nextNode = this.leftMostNode;
                while (nextNode != null) {
                    nextNode.traversePostOrder(action);
                    nextNode = nextNode.rightSiblingNode;
                }
            }
            action.perform(this);
        }
    }

    @Override
    public int height() {
        if (this.isLeaf()) {
            return 0;
        }
        int height = 0;
        LinkedMultiTreeNode<T> nextNode = this.leftMostNode;
        while (nextNode != null) {
            height = Math.max(height, nextNode.height());
            nextNode = nextNode.rightSiblingNode;
        }
        return height + 1;
    }

    @Override
    public Collection<? extends MultiTreeNode<T>> siblings() {
        if (this.isRoot()) {
            String message = String.format("Unable to find the siblings. The tree node %1$s is root", this.root());
            throw new TreeNodeException(message);
        }
        LinkedMultiTreeNode<T> firstNode = ((LinkedMultiTreeNode)this.parent()).leftMostNode;
        if (firstNode.rightSiblingNode == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<LinkedMultiTreeNode<T>> siblings = new LinkedHashSet<LinkedMultiTreeNode<T>>();
        LinkedMultiTreeNode<T> nextNode = firstNode;
        while (nextNode != null) {
            if (!nextNode.equals(this)) {
                siblings.add(nextNode);
            }
            nextNode = nextNode.rightSiblingNode;
        }
        return siblings;
    }
}

