/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.reflect;

import com.ejianc.framework.core.kit.base.ExceptionUtil;
import com.ejianc.framework.core.kit.base.ObjectUtil;
import com.ejianc.framework.core.kit.base.type.UncheckedException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ReflectionUtil {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    public static Method getSetterMethod(Class<?> clazz, String propertyName, Class<?> parameterType) {
        String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        return ReflectionUtil.getMethod(clazz, setterMethodName, parameterType);
    }

    public static Method getGetterMethod(Class<?> clazz, String propertyName) {
        String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        Method method = ReflectionUtil.getMethod(clazz, getterMethodName, new Class[0]);
        if (method == null) {
            getterMethodName = IS_PREFIX + StringUtils.capitalize((String)propertyName);
            method = ReflectionUtil.getMethod(clazz, getterMethodName, new Class[0]);
        }
        return method;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method method = MethodUtils.getMatchingMethod(clazz, (String)methodName, (Class[])parameterTypes);
        if (method != null) {
            ReflectionUtil.makeAccessible(method);
        }
        return method;
    }

    public static Method getAccessibleMethodByName(Class clazz, String methodName) {
        Validate.notNull((Object)clazz, (String)"clazz can't be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                ReflectionUtil.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static Field getField(Class clazz, String fieldName) {
        Validate.notNull((Object)clazz, (String)"clazz can't be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)fieldName, (String)"fieldName can't be blank", (Object[])new Object[0]);
        for (Class superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ReflectionUtil.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static <T> T invokeGetter(Object obj, String propertyName) {
        Method method = ReflectionUtil.getGetterMethod(obj.getClass(), propertyName);
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + propertyName + "] on target [" + obj + ']');
        }
        return ReflectionUtil.invokeMethod(obj, method, new Object[0]);
    }

    public static void invokeSetter(Object obj, String propertyName, Object value) {
        Method method = ReflectionUtil.getSetterMethod(obj.getClass(), propertyName, value.getClass());
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + propertyName + "] on target [" + obj + ']');
        }
        ReflectionUtil.invokeMethod(obj, method, value);
    }

    public static <T> T getFieldValue(Object obj, String fieldName) {
        Field field = ReflectionUtil.getField(obj.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + ']');
        }
        return ReflectionUtil.getFieldValue(obj, field);
    }

    public static <T> T getFieldValue(Object obj, Field field) {
        try {
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectionUtil.getField(obj.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + ']');
        }
        ReflectionUtil.setField(obj, field, value);
    }

    public static void setField(Object obj, Field field, Object value) {
        try {
            field.set(obj, value);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static <T> T getProperty(Object obj, String propertyName) {
        Method method = ReflectionUtil.getGetterMethod(obj.getClass(), propertyName);
        if (method != null) {
            return ReflectionUtil.invokeMethod(obj, method, new Object[0]);
        }
        return ReflectionUtil.getFieldValue(obj, propertyName);
    }

    public static void setProperty(Object obj, String propertyName, Object value) {
        Method method = ReflectionUtil.getSetterMethod(obj.getClass(), propertyName, value.getClass());
        if (method != null) {
            ReflectionUtil.invokeMethod(obj, method, value);
        } else {
            ReflectionUtil.setFieldValue(obj, propertyName, value);
        }
    }

    public static <T> T invokeMethod(Object obj, String methodName, Object ... args) {
        Object[] theArgs = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])theArgs);
        return ReflectionUtil.invokeMethod(obj, methodName, theArgs, parameterTypes);
    }

    public static <T> T invokeMethod(Object obj, String methodName, Object[] args, Class<?>[] parameterTypes) {
        Method method = ReflectionUtil.getMethod(obj.getClass(), methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] with parameter types:" + ObjectUtil.toPrettyString(parameterTypes) + " on class [" + obj.getClass() + ']');
        }
        return ReflectionUtil.invokeMethod(obj, method, args);
    }

    public static <T> T invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = ReflectionUtil.getAccessibleMethodByName(obj.getClass(), methodName);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on class [" + obj.getClass() + ']');
        }
        return ReflectionUtil.invokeMethod(obj, method, args);
    }

    public static <T> T invokeMethod(Object obj, Method method, Object ... args) {
        try {
            return (T)method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ExceptionUtil.unwrapAndUnchecked(e);
        }
    }

    public static <T> T invokeConstructor(Class<T> cls, Object ... args) {
        try {
            return (T)ConstructorUtils.invokeConstructor(cls, (Object[])args);
        }
        catch (Exception e) {
            throw ExceptionUtil.unwrapAndUnchecked(e);
        }
    }

    public static void makeAccessible(Method method) {
        if (!(method.isAccessible() || Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()))) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(field.isAccessible() || Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()))) {
            field.setAccessible(true);
        }
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new UncheckedException(e);
    }
}

