/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.commons.util.UtilAutoConfiguration;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;

@ConditionalOnProperty(value={"spring.cloud.config.discovery.enabled"}, matchIfMissing=false)
@Configuration
@Import(value={UtilAutoConfiguration.class})
@EnableDiscoveryClient
public class DiscoveryClientConfigServiceBootstrapConfiguration
implements SmartApplicationListener {
    private static Log logger = LogFactory.getLog(DiscoveryClientConfigServiceBootstrapConfiguration.class);
    @Autowired
    private ConfigClientProperties config;
    @Autowired
    private ConfigServerInstanceProvider instanceProvider;
    private HeartbeatMonitor monitor = new HeartbeatMonitor();

    @Bean
    public ConfigServerInstanceProvider configServerInstanceProvider(DiscoveryClient discoveryClient) {
        return new ConfigServerInstanceProvider(discoveryClient);
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ContextRefreshedEvent.class.isAssignableFrom(eventType) || HeartbeatEvent.class.isAssignableFrom(eventType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.startup((ContextRefreshedEvent)event);
        } else if (event instanceof HeartbeatEvent) {
            this.heartbeat((HeartbeatEvent)event);
        }
    }

    public void startup(ContextRefreshedEvent event) {
        this.refresh();
    }

    public void heartbeat(HeartbeatEvent event) {
        if (this.monitor.update(event.getValue())) {
            this.refresh();
        }
    }

    private void refresh() {
    }

    private String getHomePage(ServiceInstance server) {
        return server.getUri().toString() + "/";
    }
}

