package com.ejianc.framework.core.exception;

/** 
 * @description: 自定义业务操作异常类
 * @Date: 2019年4月14日 上午11:30:12
 */
public class BusinessException extends RootRuntimeException {
    private static final long serialVersionUID = 1L;

    private Integer errorCode;//异常码
    private String errorMsg;//描述信息
    private Throwable cause;//异常引起的原因
    
    public BusinessException() {
	}

	public BusinessException(String message) {
		this(ErrorEnum.STATUS_COMMON_EXCEPTION.getErrorCode(), message);
	}

	public BusinessException(String message, Throwable cause) {
        this(ErrorEnum.STATUS_COMMON_EXCEPTION.getErrorCode(), message, cause);
	}

	public BusinessException(Throwable cause) {
		super(cause);
	}

	protected BusinessException(String message, Throwable cause, boolean enableSuppression,
			boolean writableStackTrace) {
		super(message, cause, enableSuppression, writableStackTrace);
	}
	
    /**
     * 自定义异常构造方法
     * 
     * @param：errorCode 错误码
     */
    public BusinessException(Integer errorCode){
        String errorMsg = ErrorEnum.getErrorMsgByCode(errorCode);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }
    
    /**
     * 自定义异常构造方法
     *
     * @param：errorCode 错误码
     * @param：msgDetail 自定义错误详细信息
     */
    public BusinessException(Integer errorCode, String msgDetail){
        this.errorCode = errorCode;
        this.errorMsg = msgDetail;
    }
    
    /**
     * 直接使用错误枚举进行异常错误抛出
     * 例如：throw new BusinessException(ErrorEnum.STATUS_COMMON_EXCEPTION)
     * @param error
     */
    public BusinessException(IErrorEnum error){
        this.errorCode = error.getErrorCode();
        this.errorMsg = error.getErrorMsg();
    }
    
    /**
     * 自定义异常构造方法
     * 
     * @param：errorCode 错误码
     * @param：cause 异常引发原因
     */
    public BusinessException(Integer errorCode, Throwable cause){
        String errorMsg = ErrorEnum.getErrorMsgByCode(errorCode);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.cause = cause;
    }

    public BusinessException(Integer errorCode, String errorMsg, Throwable cause){
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.cause = cause;
    }

    public Integer getErrorCode() {
        return errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }
    
    public Throwable getCause() {
        return cause;
    }

    @Override
    public String getMessage() {
        return null != this.errorMsg ? this.errorMsg : super.getMessage();
    }
}