package com.ejianc.framework.core.exception;

/** 
 * @ClassName: ErrorEnum
 * @description: Exception错误码
 * @author: yanyuf
 * @Date: 2019年4月12日 下午4:48:49
 */
public enum ErrorEnum implements IErrorEnum{
	STATUS_COMMON_EXCEPTION(1, "通用异常错误"),
	STATUS_PARAM_ERROR(-9998, "参数验证失败"),
	STATUS_UNLOGIN_ERROR(-9997, "用户未登录"),
	STATUS_PERMISSION_DENIED_ERROR(-9996, "没有权限"),
	STATUS_VALIDATE_CODE_ERROR(-9995, "验证码错误"),
	STATUS_INVITATION_CODE_ERROR(-9994, "邀请码不存在"),
	STATUS_CONCURENT_CODE_ERROR(-9993, "并发操作失败"),
	STATUS_FREQUENT_CODE_ERROR(-9992, "操作太频繁"),
	STATUS_RETRY_CODE_ERROR(-9991, "操作失败，请重新操作"),
	STATUS_DATA_DUPLICATION_CODE_ERROR(-9990, "数据重复"),
	STATUS_INSERT_ERROR(-9989, "新增失败"),
	STATUS_UPDATE_ERROR(-9988, "更新失败"),
	STATUS_DELETE_ERROR(-9987, "删除失败");
    
    private final Integer errorCode;//异常码
    private final String errorMsg;//异常描述信息
    @Override
    public Integer getErrorCode() {
        return errorCode;
    }
    @Override
    public String getErrorMsg() {
        return errorMsg;
    }

    ErrorEnum(Integer errorCode, String errorMsg){
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }
    
    /**
     * 根据错误码获取枚举对象
     */
    public static ErrorEnum getErrorByCode(Integer errorCode){
        if(null == errorCode){
            return null;
        }
        for(ErrorEnum errorEnum : ErrorEnum.values()){
            if(errorEnum.getErrorCode() == errorCode){
                return errorEnum;
            }
        }
        return null;
    }
    
    /**
     * 根据errorCode获取错误信息
     */
    public static String getErrorMsgByCode(Integer errorCode){
        if(errorCode == null){
            return "";
        }
        ErrorEnum errorEnum = getErrorByCode(errorCode);
        if(null != errorEnum){
            return errorEnum.getErrorMsg();
        }
        return "";
    }
    
    @Override
	public String toString() {
		return "ReturnEnum{" + "code='" + errorCode + '\'' + ", message='" + errorMsg + '\'' + '}';
	}

}
