package org.springframework.cloud.config.client;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author Spencer Gibb
 */
@ConfigurationProperties("health.config")
public class ConfigClientHealthProperties {
	/**
	 * Flag to indicate that the config server health indicator should be
	 * installed.
	 */
	boolean enabled;

	/**
	 * Time to live for cached result, in milliseconds. Default 300000 (5 min).
	 */
	private long timeToLive = 60 * 5 * 1000;

	public boolean isEnabled() {
		return this.enabled;
	}

	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}

	public long getTimeToLive() {
		return timeToLive;
	}

	public void setTimeToLive(long timeToLive) {
		this.timeToLive = timeToLive;
	}
}
