package com.ejianc.framework.core.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import com.ejianc.framework.core.context.InvocationInfoProxy;

@Component
public class EnvironmentTools {
	private static final Logger logger = LoggerFactory.getLogger(EnvironmentTools.class);
	
	public final static String CUSTOM_CHANNEL = "custom_into_channel";
	public final static String DINGDING_CHANNEL = "dingding_channel";
	public final static String SELF_CHANNEL = "self_channel";
	public final static String WEIXINEE_CHANNEL = "weixinee_channel";
	public final static String OEM_CHANNEL="oem_channel";
	public final static String CUSTOM_BASE_HOST = "custom_base_host";
	
	@Value("${common.env.base-host}")
	private String baseHost;
	@Value("${ejc.metadata.web.serverName:null}")
	private String metaDataBaseUrl;

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	
	public void clearCustomerChannel(String tenantId) {
		redisTemplate.opsForHash().delete(CUSTOM_CHANNEL, tenantId);
	}
	
	public void putCustomerChannel(Long tenantId, String channel) {
		String customerChannel = (String) redisTemplate.opsForHash().get(CUSTOM_CHANNEL, tenantId+"");
		if(StringUtils.isBlank(customerChannel) && StringUtils.isNotBlank(channel)) {
			redisTemplate.opsForHash().put(CUSTOM_CHANNEL, tenantId+"", channel);
		}
	}

	public String getBaseHost() {
		Long tenantid = InvocationInfoProxy.getTenantid();
		if(tenantid != null && tenantid > 0l) {
			try {
				String customerChannel = (String) redisTemplate.opsForHash().get(CUSTOM_CHANNEL, tenantid+"");
				if(DINGDING_CHANNEL.equals(customerChannel)) {
					return Utils.getDingDingDomain()+"/";
				}
				if(OEM_CHANNEL.equals(customerChannel)) {
					String customHost = (String) redisTemplate.opsForHash().get(CUSTOM_BASE_HOST, tenantid+"");
					return customHost+"/";
				}
			} catch (Exception e) {
				logger.info("redis connection exception");
			}
		}
		return baseHost;
	}
	
	public String getMetaDataBaseUrl() {
		Long tenantid = InvocationInfoProxy.getTenantid();
		if(tenantid != null && tenantid > 0l) {
			try {
				String customerChannel = (String) redisTemplate.opsForHash().get(CUSTOM_CHANNEL, tenantid+"");
				if(DINGDING_CHANNEL.equals(customerChannel)) {
					return Utils.getDingDingDomain()+"/";
				}
				if(OEM_CHANNEL.equals(customerChannel)) {
					String customHost = (String) redisTemplate.opsForHash().get(CUSTOM_BASE_HOST, tenantid+"");
					return customHost+"/";
				}
			} catch (Exception e) {
				logger.info("redis connection exception");
			}
		}
		return metaDataBaseUrl;
	} 
	
	public String getBaseHost(Long tenantid) {
		if(tenantid != null && tenantid > 0l) {
			try {
				String customerChannel = (String) redisTemplate.opsForHash().get(CUSTOM_CHANNEL, tenantid+"");
				if(DINGDING_CHANNEL.equals(customerChannel)) {
					return Utils.getDingDingDomain()+"/";
				}
				if(OEM_CHANNEL.equals(customerChannel)) {
					String customHost = (String) redisTemplate.opsForHash().get(CUSTOM_BASE_HOST, tenantid+"");
					return customHost+"/";
				}
			} catch (Exception e) {
				logger.info("redis connection exception");
			}
		}
		return baseHost;
	}
	
	public String getMetaDataBaseUrl(Long tenantid) {
		if(tenantid != null && tenantid > 0l) {
			try {
				String customerChannel = (String) redisTemplate.opsForHash().get(CUSTOM_CHANNEL, tenantid+"");
				if(DINGDING_CHANNEL.equals(customerChannel)) {
					return Utils.getDingDingDomain()+"/";
				}
				if(OEM_CHANNEL.equals(customerChannel)) {
					String customHost = (String) redisTemplate.opsForHash().get(CUSTOM_BASE_HOST, tenantid+"");
					return customHost+"/";
				}
			} catch (Exception e) {
				logger.info("redis connection exception");
			}
		}
		return metaDataBaseUrl;
	} 

}
