package com.ejianc.framework.core.context;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * spring应用上下文工具类
 * 
 * @author mrsir  2023-03-30
 */
public class ContextCoreUtil implements ApplicationContextAware {
    private static ApplicationContext applicationContext; //应用上下文对象

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ContextCoreUtil.applicationContext = applicationContext;
    }

    @SuppressWarnings("unused")
	private static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static <T> T getBean(String beanName, Class<T> cls) {
        return applicationContext.getBean(beanName, cls);
    }
    public static <T> T getBeanByType( Class<T> cls) {
        return applicationContext.getBean(cls);
    }

    public static <T> T getBean(Class<T> cls) {
        return applicationContext.getBean(cls);
    }
}
