package com.ejianc.framework.core.response;

import java.io.Serializable;

public class Parameter implements Serializable {
	private static final long serialVersionUID = 1L;
	
	private String inputType;
	private String type = "eq";
	private Object value;

	public String getInputType() {
		return inputType;
	}

	public void setInputType(String inputType) {
		this.inputType = inputType;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	public Parameter() {
	}

	public static Parameter getEqInstance(Object value){
		return new Parameter(QueryParam.EQ,value);
	}

	public static Parameter getInInstance(Object value){
		return new Parameter(QueryParam.IN,value);
	}

	public Parameter(String type, Object value) {
		super();
		this.type = type;
		this.value = value;
	}
	public Parameter(String type, Object value,String inputType) {
		super();
		this.type = type;
		this.value = value;
		this.inputType = inputType;
	}

}