package com.ejianc.framework.core.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import jodd.util.StringUtil;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DistanceUtil {

	private static double  DEF_PI =Math.PI;// 3.14159265359
	private static double  DEF_2PI =2 *Math.PI;// 6.28318530712
	private static double  DEF_PI180 =Math.PI/ 180.0;// 0.01745329252
	private static double  DEF_R =6370996.81;// 地球的半径

	/**
	 * 通过两点的经纬度计算两点直线距离
	 * @param lng1Str  终端经度
	 * @param lat1Str  终端纬度
	 * @param lng2Str  商家经度
	 * @param lat2Str  商家纬度
	 * @return 返回的值四舍五入并保留两位小数,单位米
	 */
	public static Double getTwopointsDistance(String lng1Str,String lat1Str, String lng2Str,String lat2Str) {
		if ((StringUtil.isBlank(lat1Str)) || (StringUtil.isBlank(lng1Str))
				|| (StringUtil.isBlank(lat2Str))
				|| (StringUtil.isBlank(lng2Str))){return null;}

		Double lon1 = Double.parseDouble(lng1Str.trim());
		Double lat1 = Double.parseDouble(lat1Str.trim());
		Double lon2 = Double.parseDouble(lng2Str.trim());
		Double lat2 = Double.parseDouble(lat2Str.trim());

		// 角度转换为弧度
		double ew1 =  lon1 * DEF_PI180;
		double ns1 =  lat1 * DEF_PI180;
		double ew2 =  lon2 * DEF_PI180;
		double ns2 =  lat2 * DEF_PI180;

		// 求大圆劣弧与球心所夹的角(弧度)
		double distance = Math.sin(ns1) * Math.sin(ns2)+ Math.cos(ns1)* Math.cos(ns2)* Math.cos(ew1- ew2);
		// 调整到[-1..1]范围内，避免溢出
		if(distance >1.0) distance = 1.0;
		else if(distance <-1.0) distance = -1.0;
		distance = DEF_R *Math.acos(distance);

		//格式化返回值
		BigDecimal bd = new BigDecimal(distance);
		return distance = bd.setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();
	}

	/**
	 * 判断两点距离是否在比较距离之内
	 * @param distance 需要比较的距离
	 * @param origin  起点经纬度，以,隔开
	 * @param destination  终点经纬度，以,隔开
	 * @return
	 */
	public static Boolean isWithin(Double distance,String origin,String destination){
		String startLng = origin.split(",")[0];
		String startLat = origin.split(",")[1];
		String endLng = destination.split(",")[0];
		String endLat = destination.split(",")[1];
		if ((StringUtil.isBlank(startLat)) || (StringUtil.isBlank(startLng))
				|| (StringUtil.isBlank(endLat))
				|| (StringUtil.isBlank(endLng))){return false;}
		Double calDistance =  getTwopointsDistance(startLng,startLat,endLng,endLat);
		if(calDistance !=null){
			boolean result = distance >= (calDistance.intValue()) ? true : false;
			return result;
		}
		return false;
	}

	/**
	 * 获取两点距离的距离
	 * @param origins  起点经纬度，以,隔开
	 * @param destination  终点经纬度，以,隔开
	 * @return
	 */
	public static JSONArray getDistance(List<String> origins, String destination){
		JSONArray list = new JSONArray();
		String endLng = destination.split(",")[0];
		String endLat = destination.split(",")[1];
		for(String origin : origins){
			String startLng = origin.split(",")[0];
			String startLat = origin.split(",")[1];
			Double calDistance =  getTwopointsDistance(startLng,startLat,endLng,endLat);
			JSONObject json = new JSONObject();
			json.put("origin", origin);
			json.put("destination", destination);
			json.put("distance", calDistance);
			list.add(json);
		}
		return list;
	}

	public static void main(String[] args){
		boolean ss = isWithin(100.0, "144,136.1332", "144,136.1338");
		System.out.println(ss);
	}

}