package com.ejianc.framework.core.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.ContextCoreUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.core.io.ClassPathResource;

import net.sf.jxls.transformer.XLSTransformer;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class ExcelExport {
	private ExcelExport() {
		System.out.println("============jxls导出 初始化===========");
	}

	private static ExcelExport excelExport = null;
	private static HttpMessageConverters httpMessageConverters  = null;
	public synchronized static ExcelExport getInstance() {
		if (excelExport == null) {
			httpMessageConverters = ContextCoreUtil.getBeanByType(HttpMessageConverters.class);
			excelExport = new ExcelExport();
		}
		return excelExport;
	}

	/**
	 * 列表数据导出 不支持参照、档案的自动翻译，需要自己翻译
	 * 不推荐使用本方法，推荐使用exportWithTrans方法
	 * @param data
	 *            待导出的数据
	 * @param exitsName
	 *            导出excel的名称
	 * @throws InvalidFormatException
	 */
	@Deprecated
	public void export(String exitsName, Map<String, Object> data, HttpServletResponse response) {
		export(exitsName, data, response, null);
	}

	/**
	 * 列表数据导出 不支持参照、档案的自动翻译，需要自己翻译
	 * 不推荐使用本方法，推荐使用exportWithTrans方法
	 * @param data
	 *            待导出的数据
	 * @param exitsName
	 *            导出excel的名称
	 * @throws InvalidFormatException
	 */
	@Deprecated
	public void export(String exitsName, Map<String, Object> data, HttpServletResponse response, String excelExportTitle) {
		XLSTransformer transformer = new XLSTransformer();
		ServletOutputStream outputStream = null;
		try {
			SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatUtil.PATTERN_ISO_ON_DATE);
			SimpleDateFormat timeFormat = new SimpleDateFormat(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND);
			data.put("dateFormat",dateFormat);
			data.put("timeFormat",timeFormat);
			ClassPathResource resource = new ClassPathResource("excel/" + exitsName);
			outputStream = response.getOutputStream();
			Workbook workbook = transformer.transformXLS(resource.getInputStream(), data);

			if(StringUtils.isNotBlank(excelExportTitle)) {
				workbook.getSheetAt(0).getRow(0).getCell(0).setCellValue(excelExportTitle);
			}

			workbook.write(outputStream);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {

			if (outputStream != null) {
				try {
					outputStream.flush();
					outputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 列表数据导出 支持参照、档案的自动翻译
	 * 推荐使用本方法
	 * @param data
	 *            待导出的数据
	 * @param exitsName
	 *            导出excel的名称
	 * @throws InvalidFormatException
	 */
	public void exportWithTrans(String exitsName, Map<String, Object> data, HttpServletResponse response) {
		exportWithTrans(exitsName, data, response, null);
	}

	/**
	 * 列表数据导出 支持参照、档案的自动翻译
	 * 推荐使用本方法
	 * @param data
	 *            待导出的数据
	 * @param exitsName
	 *            导出excel的名称
	 * @throws InvalidFormatException
	 */
	public void exportWithTrans(String exitsName, Map<String, Object> data, HttpServletResponse response, String excelExportTitle) {
		XLSTransformer transformer = new XLSTransformer();
		ServletOutputStream outputStream = null;
		try {
			ClassPathResource resource = new ClassPathResource("excel/" + exitsName);
			outputStream = response.getOutputStream();
			List<Object> records = (List<Object>)data.get("records");
			List<JSONObject> result = new ArrayList<>();
			List<HttpMessageConverter<?>> converters = httpMessageConverters.getConverters();
			ObjectMapper objectMapper = null;
			for (HttpMessageConverter<?> converter : converters) {
				if(converter instanceof MappingJackson2HttpMessageConverter){
					objectMapper = ((MappingJackson2HttpMessageConverter)converter).getObjectMapper();
					break;
				}
			}
			if(ListUtil.isNotEmpty(records)){
				for (Object record : records) {
					String str = objectMapper.writeValueAsString(record);
					JSONObject obj = JSONObject.parseObject(str);
					if(StringUtils.isNotEmpty(obj.getString("billState")) && obj.getString("billState").length() == 1){
						obj.put("billState",BillStateEnum.getEnumByStateCode(obj.getInteger("billState")).getDescription());
					}
					result.add(obj);
				}
				data.put("records",result);
			}
			Workbook workbook = transformer.transformXLS(resource.getInputStream(), data);

			if(StringUtils.isNotBlank(excelExportTitle)) {
				workbook.getSheetAt(0).getRow(0).getCell(0).setCellValue(excelExportTitle);
			}
			workbook.write(outputStream);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {

			if (outputStream != null) {
				try {
					outputStream.flush();
					outputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}
}
