package com.ejianc.business.budget.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 清单定额关系明细
 *
 * @author generator
 *
 */
public class BudgetSetDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long setId; // 主表ID
    private Long setTypeId; // 类型子表ID
    private String detailCode; // 清单编码
    private String detailName; // 清单名称
    private String description; // 特征描述
    private String detailUnit; // 单位
    private BigDecimal detailNum; // 工程量
    private String quotaName; // 关联定额
    private String features; // 关键特征值
    private String memo; // 备注

    private List<BudgetSetQuotaVO> quotaList = new ArrayList<>(); // 清单定额关系定额表
    private List<BudgetSetFeaturesVO> featuresList = new ArrayList<>(); // 清单定额关系特征值


    private Integer similarWeight; //相似权重

    public Integer getSimilarWeight() {
        return similarWeight;
    }

    public void setSimilarWeight(Integer similarWeight) {
        this.similarWeight = similarWeight;
    }

    public Long getSetId() {
        return setId;
    }

    public void setSetId(Long setId) {
        this.setId = setId;
    }
    public Long getSetTypeId() {
        return setTypeId;
    }

    public void setSetTypeId(Long setTypeId) {
        this.setTypeId = setTypeId;
    }
    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }
    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }
    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }
    public String getQuotaName() {
        return quotaName;
    }

    public void setQuotaName(String quotaName) {
        this.quotaName = quotaName;
    }
    public String getFeatures() {
        return features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<BudgetSetQuotaVO> getQuotaList() {
        return quotaList;
    }

    public void setQuotaList(List<BudgetSetQuotaVO> quotaList) {
        this.quotaList = quotaList;
    }

    public List<BudgetSetFeaturesVO> getFeaturesList() {
        return featuresList;
    }

    public void setFeaturesList(List<BudgetSetFeaturesVO> featuresList) {
        this.featuresList = featuresList;
    }
}
