package com.ejianc.business.budget.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.budget.vo.BudgetProjectDetailChangeVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目预算变更单
 *
 * @author generator
 *
 */
public class BudgetProjectChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long budgetId; // 预算主键
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Integer unassociate; // 未关联科目项
    private BigDecimal budgetMny; // 预算金额
    private BigDecimal laborMny; // 人工费
    private BigDecimal materialMny; // 材料费
    private BigDecimal mechanicalMny; // 机械费
    private BigDecimal otherMny; // 其他费
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private Integer changeVersion; // 变更版本
    private String changeCode; // 变更单号
    private Integer billState; // 单据状态
    private Integer linkedFlag; // 是否关联科目
    private BigDecimal baseBudgetMoney; // 初始版本金额
    private BigDecimal beforeChangeBudgetMny; // 变更前金额
    private BigDecimal baseLaborMny; // 初始版本人工费
    private BigDecimal beforeChangeLaborMny; // 变更前人工费
    private BigDecimal baseMaterialMny; // 初始版本材料费
    private BigDecimal beforeChangeMaterialMny; // 变更前材料费
    private BigDecimal baseMechanicalMny; // 初始版本机械费
    private BigDecimal beforeChangeMechanicalMny; // 变更前机械费
    private BigDecimal baseOtherMny; // 初始版本其他费用
    private BigDecimal beforeChangeOtherMny; // 变更前其他费用
    private String changeReason; // 变更原因
    private Integer budgetType; // 预算类型：1-中标预算2-施工图预算3-结算预算4签证5-其他
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private BigDecimal totalMny; // 预算总金额
    private BigDecimal baseTotalMny; // 初始版本预算总金额
    private BigDecimal beforeChangeTotalMny; // 变更前预算总金额
    private BigDecimal changingTotalMny; // 变更中预算总金额
    /**
     * 生效时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date usedTime;
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String historyBillCode; // 组织名称

    private List<BudgetProjectDetailChangeVO> checkList = new ArrayList<>(); // 项目预算变更清单


    public String getHistoryBillCode() {
        return historyBillCode;
    }

    public void setHistoryBillCode(String historyBillCode) {
        this.historyBillCode = historyBillCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getChangeReason() {
        return changeReason;
    }


    public Date getUsedTime() {
        return usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    /**
     * 预算主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 未关联科目项
     */
    public Integer getUnassociate() {
        return unassociate;
    }

    /**
     * 未关联科目项
     */
    public void setUnassociate(Integer unassociate) {
        this.unassociate = unassociate;
    }
    /**
     * 预算金额
     */
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    /**
     * 预算金额
     */
    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    /**
     * 人工费
     */
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    /**
     * 人工费
     */
    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    /**
     * 材料费
     */
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    /**
     * 材料费
     */
    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    /**
     * 机械费
     */
    public BigDecimal getMechanicalMny() {
        return mechanicalMny;
    }

    /**
     * 机械费
     */
    public void setMechanicalMny(BigDecimal mechanicalMny) {
        this.mechanicalMny = mechanicalMny;
    }
    /**
     * 其他费
     */
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    /**
     * 其他费
     */
    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 是否关联科目
     */
    public Integer getLinkedFlag() {
        return linkedFlag;
    }

    /**
     * 是否关联科目
     */
    public void setLinkedFlag(Integer linkedFlag) {
        this.linkedFlag = linkedFlag;
    }
    /**
     * 初始版本金额
     */
    public BigDecimal getBaseBudgetMoney() {
        return baseBudgetMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseBudgetMoney(BigDecimal baseBudgetMoney) {
        this.baseBudgetMoney = baseBudgetMoney;
    }
    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeBudgetMny() {
        return beforeChangeBudgetMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeBudgetMny(BigDecimal beforeChangeBudgetMny) {
        this.beforeChangeBudgetMny = beforeChangeBudgetMny;
    }
    /**
     * 初始版本人工费
     */
    public BigDecimal getBaseLaborMny() {
        return baseLaborMny;
    }

    /**
     * 初始版本人工费
     */
    public void setBaseLaborMny(BigDecimal baseLaborMny) {
        this.baseLaborMny = baseLaborMny;
    }
    /**
     * 变更前人工费
     */
    public BigDecimal getBeforeChangeLaborMny() {
        return beforeChangeLaborMny;
    }

    /**
     * 变更前人工费
     */
    public void setBeforeChangeLaborMny(BigDecimal beforeChangeLaborMny) {
        this.beforeChangeLaborMny = beforeChangeLaborMny;
    }
    /**
     * 初始版本材料费
     */
    public BigDecimal getBaseMaterialMny() {
        return baseMaterialMny;
    }

    /**
     * 初始版本材料费
     */
    public void setBaseMaterialMny(BigDecimal baseMaterialMny) {
        this.baseMaterialMny = baseMaterialMny;
    }
    /**
     * 变更前材料费
     */
    public BigDecimal getBeforeChangeMaterialMny() {
        return beforeChangeMaterialMny;
    }

    /**
     * 变更前材料费
     */
    public void setBeforeChangeMaterialMny(BigDecimal beforeChangeMaterialMny) {
        this.beforeChangeMaterialMny = beforeChangeMaterialMny;
    }
    /**
     * 初始版本机械费
     */
    public BigDecimal getBaseMechanicalMny() {
        return baseMechanicalMny;
    }

    /**
     * 初始版本机械费
     */
    public void setBaseMechanicalMny(BigDecimal baseMechanicalMny) {
        this.baseMechanicalMny = baseMechanicalMny;
    }
    /**
     * 变更前机械费
     */
    public BigDecimal getBeforeChangeMechanicalMny() {
        return beforeChangeMechanicalMny;
    }

    /**
     * 变更前机械费
     */
    public void setBeforeChangeMechanicalMny(BigDecimal beforeChangeMechanicalMny) {
        this.beforeChangeMechanicalMny = beforeChangeMechanicalMny;
    }
    /**
     * 初始版本其他费用
     */
    public BigDecimal getBaseOtherMny() {
        return baseOtherMny;
    }

    /**
     * 初始版本其他费用
     */
    public void setBaseOtherMny(BigDecimal baseOtherMny) {
        this.baseOtherMny = baseOtherMny;
    }
    /**
     * 变更前其他费用
     */
    public BigDecimal getBeforeChangeOtherMny() {
        return beforeChangeOtherMny;
    }

    /**
     * 变更前其他费用
     */
    public void setBeforeChangeOtherMny(BigDecimal beforeChangeOtherMny) {
        this.beforeChangeOtherMny = beforeChangeOtherMny;
    }

    public Integer getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(Integer budgetType) {
        this.budgetType = budgetType;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public BigDecimal getBaseTotalMny() {
        return baseTotalMny;
    }

    public void setBaseTotalMny(BigDecimal baseTotalMny) {
        this.baseTotalMny = baseTotalMny;
    }

    public BigDecimal getBeforeChangeTotalMny() {
        return beforeChangeTotalMny;
    }

    public void setBeforeChangeTotalMny(BigDecimal beforeChangeTotalMny) {
        this.beforeChangeTotalMny = beforeChangeTotalMny;
    }

    public BigDecimal getChangingTotalMny() {
        return changingTotalMny;
    }

    public void setChangingTotalMny(BigDecimal changingTotalMny) {
        this.changingTotalMny = changingTotalMny;
    }

    public List<BudgetProjectDetailChangeVO> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<BudgetProjectDetailChangeVO> checkList) {
        this.checkList = checkList;
    }
}
