package com.ejianc.business.cost.utils;


import java.util.*;

/**
 * @author beibeiup
 */
public class TreeNodeBUtil {
  /**
   * 构建树
   *
   * @param values 需要组建树的数据List
   * @param <T> 数据类型
   * @return 树的根节点
   */
  public static <T extends ITreeNodeB> List<T> buildTree(List<T> values) {
    Map<Long, T> nodeMap = new HashMap<>();
    List<T> result = new ArrayList<>();
    List<T> emptyValueList = new ArrayList<>();
    for (T value : values) {
      if (null==value.getParentID()||value.getParentID()==0) {
        result.add(value);
      } else {
        T parentNode = nodeMap.get(value.getParentID());
        if (parentNode == null) {
          emptyValueList.add(value);
        } else {
          parentNode.getChildren().add(value);
        }
      }
      nodeMap.put(value.getNodeID(), value);
    }
    if (!emptyValueList.isEmpty()) {
      for (T value : emptyValueList) {
        T parentNode = nodeMap.get(value.getParentID());
        if (parentNode == null) {
          result.add(value);
        } else {
          parentNode.getChildren().add(value);
        }
      }
    }
    return result;
  }

  public static List<Map<String, Object>> createTreeData(List<Map> list) {
    List<Map<String, Object>> resp = new ArrayList();
    List<String> rootItems = new ArrayList();
    Map<String, Map<String, Object>> listMap = new HashMap();
    Iterator var4 = list.iterator();

    Map item;
    while(var4.hasNext()) {
      item = (Map)var4.next();
      listMap.put(item.get("id").toString(), item);
    }

    for(int i = 0; i < list.size(); ++i) {
      item = (Map)list.get(i);
      String parentId = item.get("parentId") != null ? item.get("parentId").toString() : "";
      Map<String, Object> parent = (Map)listMap.get(parentId);
      if (parent != null) {
        List<Map<String, Object>> child = (List)parent.get("children");
        if (child != null) {
          child.add(item);
        } else {
          List<Map<String, Object>> children = new ArrayList();
          children.add(item);
          parent.put("children", children);
        }
      } else {
        rootItems.add(item.get("id").toString());
      }
    }

    var4 = rootItems.iterator();

    while(var4.hasNext()) {
      String rootId = (String)var4.next();
      resp.add(listMap.get(rootId));
    }

    return resp;
  }
}
